/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.abt;

import android.support.annotation.VisibleForTesting;
import com.google.firebase.abt.AbtException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public final class zza {
    private static final String[] zza = new String[]{"experimentId", "experimentStartTime", "timeToLiveMillis", "triggerTimeoutMillis", "variantId"};
    @VisibleForTesting
    private static final DateFormat zzb = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
    private final String zzc;
    private final String zzd;
    private final String triggerEventName;
    private final Date zze;
    private final long zzf;
    private final long zzg;

    @VisibleForTesting
    private zza(String string, String string2, String string3, Date date, long l, long l2) {
        this.zzc = string;
        this.zzd = string2;
        this.triggerEventName = string3;
        this.zze = date;
        this.zzf = l;
        this.zzg = l2;
    }

    static zza zza(Map<String, String> map) throws AbtException {
        Map<String, String> map2 = map;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = zza;
        int n = zza.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (map2.containsKey(string)) continue;
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            throw new AbtException(String.format("The following keys are missing from the experiment info map: %s", arrayList));
        }
        try {
            Date date = zzb.parse(map.get("experimentStartTime"));
            long l = Long.parseLong(map.get("triggerTimeoutMillis"));
            long l2 = Long.parseLong(map.get("timeToLiveMillis"));
            return new zza(map.get("experimentId"), map.get("variantId"), map.containsKey("triggerEvent") ? map.get("triggerEvent") : "", date, l, l2);
        }
        catch (ParseException parseException) {
            throw new AbtException("Could not process experiment: parsing experiment start time failed.", parseException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbtException("Could not process experiment: one of the durations could not be converted into a long.", numberFormatException);
        }
    }

    final String zza() {
        return this.zzc;
    }

    final String zzb() {
        return this.zzd;
    }

    final String zzc() {
        return this.triggerEventName;
    }

    final long zzd() {
        return this.zze.getTime();
    }

    final long zze() {
        return this.zzf;
    }

    final long zzf() {
        return this.zzg;
    }
}

