/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.Hex;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.appcheck.FirebaseAppCheck;
import com.google.firebase.appcheck.internal.AppCheckTokenResponse;
import com.google.firebase.appcheck.internal.DefaultFirebaseAppCheck;
import com.google.firebase.appcheck.internal.HttpErrorResponse;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONException;

public class NetworkClient {
    private static final String TAG = NetworkClient.class.getName();
    private static final String SAFETY_NET_EXCHANGE_URL_TEMPLATE = "https://firebaseappcheck.googleapis.com/v1beta/projects/%s/apps/%s:exchangeSafetyNetToken?key=%s";
    private static final String DEBUG_EXCHANGE_URL_TEMPLATE = "https://firebaseappcheck.googleapis.com/v1beta/projects/%s/apps/%s:exchangeDebugToken?key=%s";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    @VisibleForTesting
    static final String X_FIREBASE_CLIENT = "X-Firebase-Client";
    @VisibleForTesting
    static final String X_FIREBASE_CLIENT_LOG_TYPE = "X-Firebase-Client-Log-Type";
    @VisibleForTesting
    static final String X_ANDROID_PACKAGE = "X-Android-Package";
    @VisibleForTesting
    static final String X_ANDROID_CERT = "X-Android-Cert";
    private final Context context;
    private final DefaultFirebaseAppCheck firebaseAppCheck;
    private final String apiKey;
    private final String appId;
    private final String projectId;
    public static final int UNKNOWN = 0;
    public static final int SAFETY_NET = 1;
    public static final int DEBUG = 2;

    public NetworkClient(@NonNull FirebaseApp firebaseApp) {
        Preconditions.checkNotNull((Object)firebaseApp);
        this.context = firebaseApp.getApplicationContext();
        this.firebaseAppCheck = (DefaultFirebaseAppCheck)FirebaseAppCheck.getInstance(firebaseApp);
        this.apiKey = firebaseApp.getOptions().getApiKey();
        this.appId = firebaseApp.getOptions().getApplicationId();
        this.projectId = firebaseApp.getOptions().getProjectId();
        if (this.projectId == null) {
            throw new IllegalArgumentException("FirebaseOptions#getProjectId cannot be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AppCheckTokenResponse exchangeAttestationForAppCheckToken(@NonNull byte[] requestBytes, int tokenType) throws FirebaseException, IOException, JSONException {
        URL url = new URL(String.format(NetworkClient.getUrlTemplate(tokenType), this.projectId, this.appId, this.apiKey));
        HttpURLConnection urlConnection = this.createHttpUrlConnection(url);
        try {
            urlConnection.setDoOutput(true);
            urlConnection.setFixedLengthStreamingMode(requestBytes.length);
            urlConnection.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
            if (this.firebaseAppCheck.getUserAgent() != null) {
                urlConnection.setRequestProperty(X_FIREBASE_CLIENT, this.firebaseAppCheck.getUserAgent());
            }
            if (this.firebaseAppCheck.getHeartbeatCode() != null) {
                urlConnection.setRequestProperty(X_FIREBASE_CLIENT_LOG_TYPE, this.firebaseAppCheck.getHeartbeatCode());
            }
            urlConnection.setRequestProperty(X_ANDROID_PACKAGE, this.context.getPackageName());
            urlConnection.setRequestProperty(X_ANDROID_CERT, this.getFingerprintHashForPackage());
            try (BufferedOutputStream out = new BufferedOutputStream(urlConnection.getOutputStream(), requestBytes.length);){
                ((OutputStream)out).write(requestBytes, 0, requestBytes.length);
            }
            int responseCode = urlConnection.getResponseCode();
            InputStream in = NetworkClient.isResponseSuccess(responseCode) ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            String responseBody = response.toString();
            if (!NetworkClient.isResponseSuccess(responseCode)) {
                HttpErrorResponse httpErrorResponse = HttpErrorResponse.fromJsonString(responseBody);
                throw new FirebaseException("Error returned from API. code: " + httpErrorResponse.getErrorCode() + " body: " + httpErrorResponse.getErrorMessage());
            }
            AppCheckTokenResponse appCheckTokenResponse = AppCheckTokenResponse.fromJsonString(responseBody);
            return appCheckTokenResponse;
        }
        finally {
            urlConnection.disconnect();
        }
    }

    private String getFingerprintHashForPackage() {
        try {
            byte[] hash = AndroidUtilsLight.getPackageCertificateHashBytes((Context)this.context, (String)this.context.getPackageName());
            if (hash == null) {
                Log.e((String)TAG, (String)("Could not get fingerprint hash for package: " + this.context.getPackageName()));
                return null;
            }
            return Hex.bytesToStringUppercase((byte[])hash, (boolean)false);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("No such package: " + this.context.getPackageName()), (Throwable)e);
            return null;
        }
    }

    private static String getUrlTemplate(int tokenType) {
        switch (tokenType) {
            case 1: {
                return SAFETY_NET_EXCHANGE_URL_TEMPLATE;
            }
            case 2: {
                return DEBUG_EXCHANGE_URL_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Unknown token type.");
    }

    @VisibleForTesting
    HttpURLConnection createHttpUrlConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private static final boolean isResponseSuccess(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttestationTokenType {
    }
}

