/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzeag;
import com.google.android.gms.internal.zzeah;
import com.google.android.gms.internal.zzeai;
import com.google.android.gms.internal.zzeaj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzlea = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzleb = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzlec = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzled = Arrays.asList(new String[0]);
    private static final Set<String> zzlee = Collections.emptySet();
    private static final Object zzaqm = new Object();
    static final Map<String, FirebaseApp> zzhtf = new ArrayMap();
    private final Context mApplicationContext;
    private final String mName;
    private final FirebaseOptions zzlef;
    private final AtomicBoolean zzleg = new AtomicBoolean(false);
    private final AtomicBoolean zzleh = new AtomicBoolean();
    private final List<zzb> zzlei = new CopyOnWriteArrayList<zzb>();
    private final List<zza> zzlej = new CopyOnWriteArrayList<zza>();
    private final List<Object> zzlek = new CopyOnWriteArrayList<Object>();
    private zzeai zzlel;
    private zzc zzlem;

    @NonNull
    public Context getApplicationContext() {
        this.zzbnj();
        return this.mApplicationContext;
    }

    @NonNull
    public String getName() {
        this.zzbnj();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzbnj();
        return this.zzlef;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzbf.zzt((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzlef).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        zzeah.zzeo(context);
        Object object = zzaqm;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzhtf.values());
            zzeah.zzbyr();
            Set<String> set = zzeah.zzbys();
            set.removeAll(zzhtf.keySet());
            for (String string : set) {
                zzeah.zzqb(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zzaqm;
        synchronized (object) {
            FirebaseApp firebaseApp = zzhtf.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = zzq.zzalk();
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzaqm;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzhtf.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzbnm();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zzaqm;
        synchronized (object) {
            if (zzhtf.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzeah.zzeo(context);
        Context context2 = context;
        if (context2.getApplicationContext() instanceof Application) {
            zzk.zza((Application)((Application)context2.getApplicationContext()));
            zzk.zzafy().zza((zzl)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = zzaqm;
        synchronized (object) {
            zzbp.zza((!zzhtf.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzbp.zzb((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zzhtf.put(string2, firebaseApp);
        }
        zzeah.zze(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzlea);
        if (firebaseApp.zzbnk()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzleb);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzlec);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzbe(boolean bl) {
        Object object = zzaqm;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzhtf.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzleg.get()) continue;
                firebaseApp2.zzbx(bl);
            }
            return;
        }
    }

    public final void zza(@NonNull zzeai zzeai2) {
        this.zzlel = (zzeai)zzbp.zzu((Object)zzeai2);
    }

    public final Task<GetTokenResult> getToken(boolean bl) {
        this.zzbnj();
        if (this.zzlel == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzlel.zzby(bl);
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzbnj();
        if (this.zzleg.compareAndSet(!bl, bl)) {
            boolean bl2 = zzk.zzafy().zzafz();
            if (bl && bl2) {
                this.zzbx(true);
                return;
            }
            if (!bl && bl2) {
                this.zzbx(false);
            }
        }
    }

    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.mApplicationContext = (Context)zzbp.zzu((Object)context);
        this.mName = zzbp.zzgf((String)string);
        this.zzlef = (FirebaseOptions)zzbp.zzu((Object)firebaseOptions);
        this.zzlem = new zzeag();
    }

    private final void zzbnj() {
        zzbp.zza((!this.zzleh.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public final boolean zzbnk() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public final void zza(@NonNull zzeaj zzeaj2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<zzb> iterator = this.zzlei.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb(zzeaj2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zzbx(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<zza> iterator = this.zzlej.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzbe(bl);
        }
    }

    public final void zza(@NonNull zzb zzb2) {
        this.zzbnj();
        zzbp.zzu((Object)zzb2);
        this.zzlei.add(zzb2);
        this.zzlei.size();
    }

    public final void zza(zza zza2) {
        this.zzbnj();
        if (this.zzleg.get() && zzk.zzafy().zzafz()) {
            zza2.zzbe(true);
        }
        this.zzlej.add(zza2);
    }

    public final String zzbnl() {
        String string = com.google.android.gms.common.util.zzb.zzk((byte[])this.getName().getBytes());
        String string2 = com.google.android.gms.common.util.zzb.zzk((byte[])this.getOptions().getApplicationId().getBytes());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzbnm() {
        ArraySet arraySet = new ArraySet();
        ArrayList<String> arrayList = zzaqm;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzhtf.values()) {
                arraySet.add(firebaseApp.getName());
            }
            if (zzeah.zzbyr() != null) {
                arraySet.addAll(zzeah.zzbys());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)arraySet);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzbnn() {
        this.zza(FirebaseApp.class, this, zzlea);
        if (this.zzbnk()) {
            this.zza(FirebaseApp.class, this, zzleb);
            this.zza(Context.class, this.mApplicationContext, zzlec);
        }
    }

    private final <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.mApplicationContext);
        if (bl) {
            zzd.zzee(this.mApplicationContext);
        }
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zzled.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzlee.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @TargetApi(value=24)
    static final class zzd
    extends BroadcastReceiver {
        private static AtomicReference<zzd> zzlen = new AtomicReference();
        private final Context mApplicationContext;

        private zzd(Context context) {
            this.mApplicationContext = context;
        }

        private static void zzee(Context context) {
            zzd zzd2;
            if (zzlen.get() == null && zzlen.compareAndSet(null, zzd2 = new zzd(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzd2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = zzaqm;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zzhtf.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzbnn();
                }
            }
            zzd zzd2 = this;
            zzd2.mApplicationContext.unregisterReceiver((BroadcastReceiver)zzd2);
        }
    }

    public static interface zza {
        public void zzbe(boolean var1);
    }

    public static interface zzc {
    }

    public static interface zzb {
        public void zzb(@NonNull zzeaj var1);
    }
}

