/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.events.Event;
import com.google.firebase.events.Publisher;

public class DataCollectionConfigStorage {
    private static final String FIREBASE_APP_PREFS = "com.google.firebase.common.prefs:";
    @VisibleForTesting
    public static final String DATA_COLLECTION_DEFAULT_ENABLED = "firebase_data_collection_default_enabled";
    private final Context deviceProtectedContext;
    private final SharedPreferences sharedPreferences;
    private final Publisher publisher;
    private boolean dataCollectionDefaultEnabled;

    public DataCollectionConfigStorage(Context applicationContext, String persistenceKey, Publisher publisher) {
        this.deviceProtectedContext = DataCollectionConfigStorage.directBootSafe(applicationContext);
        this.sharedPreferences = this.deviceProtectedContext.getSharedPreferences(FIREBASE_APP_PREFS + persistenceKey, 0);
        this.publisher = publisher;
        this.dataCollectionDefaultEnabled = this.readAutoDataCollectionEnabled();
    }

    private static Context directBootSafe(Context applicationContext) {
        if (Build.VERSION.SDK_INT < 24) {
            return applicationContext;
        }
        return ContextCompat.createDeviceProtectedStorageContext((Context)applicationContext);
    }

    public synchronized boolean isEnabled() {
        return this.dataCollectionDefaultEnabled;
    }

    private synchronized void updateDataCollectionDefaultEnabled(boolean enabled) {
        if (this.dataCollectionDefaultEnabled != enabled) {
            this.dataCollectionDefaultEnabled = enabled;
            this.publisher.publish(new Event(DataCollectionDefaultChange.class, (Object)new DataCollectionDefaultChange(enabled)));
        }
    }

    public synchronized void setEnabled(Boolean enabled) {
        if (enabled == null) {
            this.sharedPreferences.edit().remove(DATA_COLLECTION_DEFAULT_ENABLED).apply();
            this.updateDataCollectionDefaultEnabled(this.readManifestDataCollectionEnabled());
        } else {
            boolean apiSetting = Boolean.TRUE.equals(enabled);
            this.sharedPreferences.edit().putBoolean(DATA_COLLECTION_DEFAULT_ENABLED, apiSetting).apply();
            this.updateDataCollectionDefaultEnabled(apiSetting);
        }
    }

    private boolean readManifestDataCollectionEnabled() {
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = this.deviceProtectedContext.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(this.deviceProtectedContext.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(DATA_COLLECTION_DEFAULT_ENABLED)) {
                return applicationInfo.metaData.getBoolean(DATA_COLLECTION_DEFAULT_ENABLED);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return true;
    }

    private boolean readAutoDataCollectionEnabled() {
        if (this.sharedPreferences.contains(DATA_COLLECTION_DEFAULT_ENABLED)) {
            return this.sharedPreferences.getBoolean(DATA_COLLECTION_DEFAULT_ENABLED, true);
        }
        return this.readManifestDataCollectionEnabled();
    }
}

