/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.DslExtension;
import com.android.build.api.variant.Variant;
import com.android.build.api.variant.VariantExtension;
import com.android.build.api.variant.VariantExtensionConfig;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryPlugin;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsBuildtools;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsExtension;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsPlugin;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsVariantExtension;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.GenerateSymbolFileTask;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.InjectBuildIdsTask;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.InjectMappingFileIdTask;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.UploadMappingFileTask;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.UploadSymbolFileTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "registerExtension", "androidComponents", "Lcom/android/build/api/variant/ApplicationAndroidComponentsExtension;", "registerTasks", "validateDependencies", "Companion", "crashlytics-gradle"})
@SourceDebugExtension(value={"SMAP\nCrashlyticsPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrashlyticsPlugin.kt\ncom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsPlugin\n+ 2 DomainObjectCollectionExtensions.kt\norg/gradle/kotlin/dsl/DomainObjectCollectionExtensionsKt\n*L\n1#1,148:1\n33#2:149\n33#2:150\n*S KotlinDebug\n*F\n+ 1 CrashlyticsPlugin.kt\ncom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsPlugin\n*L\n49#1:149\n74#1:150\n*E\n"})
public final class CrashlyticsPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CRASHLYTICS_TASK_GROUP = "Firebase Crashlytics";
    @NotNull
    private static final String CRASHLYTICS_EXTENSION_NAME = "firebaseCrashlytics";
    @NotNull
    public static final String UPGRADE_MSG = "For more information, see https://firebase.google.com/docs/crashlytics/upgrade-to-crashlytics-gradle-plugin-v3";

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        void $this$withType$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.validateDependencies(project);
        Ref.BooleanRef hasAppPluginApplied = new Ref.BooleanRef();
        PluginContainer pluginContainer = project.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.plugins");
        DomainObjectCollection domainObjectCollection = (DomainObjectCollection)pluginContainer;
        Function1 configuration$iv = (Function1)new Function1<AppPlugin, Unit>(hasAppPluginApplied, project, this){
            final /* synthetic */ Ref.BooleanRef $hasAppPluginApplied;
            final /* synthetic */ Project $project;
            final /* synthetic */ CrashlyticsPlugin this$0;
            {
                this.$hasAppPluginApplied = $hasAppPluginApplied;
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AppPlugin $this$withType) {
                Intrinsics.checkNotNullParameter((Object)$this$withType, (String)"$this$withType");
                this.$hasAppPluginApplied.element = true;
                ExtensionContainer extensionContainer = this.$project.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
                ExtensionContainer $this$getByType$iv = extensionContainer;
                boolean $i$f$getByType = false;
                boolean $i$f$typeOf = false;
                Object object = $this$getByType$iv.getByType((TypeOf)new TypeOf<ApplicationAndroidComponentsExtension>(){});
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(typeOf<T>())");
                ApplicationAndroidComponentsExtension androidComponents = (ApplicationAndroidComponentsExtension)object;
                CrashlyticsPlugin.access$validateDependencies(this.this$0, androidComponents);
                CrashlyticsPlugin.access$registerExtension(this.this$0, this.$project, androidComponents);
                CrashlyticsPlugin.access$registerTasks(this.this$0, this.$project, androidComponents);
                CrashlyticsBuildtools.INSTANCE.configure(this.$project);
            }
        };
        boolean $i$f$withType = false;
        Function1 function1 = configuration$iv;
        Intrinsics.checkNotNullExpressionValue((Object)$this$withType$iv.withType(AppPlugin.class, new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ void execute(Object p0) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
            }
        }), (String)"withType(S::class.java, configuration)");
        project.afterEvaluate(arg_0 -> CrashlyticsPlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(hasAppPluginApplied){
            final /* synthetic */ Ref.BooleanRef $hasAppPluginApplied;
            {
                this.$hasAppPluginApplied = $hasAppPluginApplied;
                super(1);
            }

            public final void invoke(Project it) {
                if (!this.$hasAppPluginApplied.element) {
                    throw new GradleException("Crashlytics requires the `com.android.application` plugin to be applied");
                }
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void validateDependencies(Project project) {
        void $this$withType$iv;
        if (GradleVersion.version((String)project.getGradle().getGradleVersion()).compareTo(GradleVersion.version((String)"8.0")) < 0) {
            throw new GradleException("The Crashlytics Gradle plugin 3 requires Gradle 8.0 or above. For more information, see https://firebase.google.com/docs/crashlytics/upgrade-to-crashlytics-gradle-plugin-v3");
        }
        PluginContainer pluginContainer = project.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.plugins");
        DomainObjectCollection domainObjectCollection = (DomainObjectCollection)pluginContainer;
        Function1 configuration$iv = validateDependencies.1.INSTANCE;
        boolean $i$f$withType = false;
        Function1 function1 = configuration$iv;
        Intrinsics.checkNotNullExpressionValue((Object)$this$withType$iv.withType(LibraryPlugin.class, new /* invalid duplicate definition of identical inner class */), (String)"withType(S::class.java, configuration)");
    }

    private final void validateDependencies(ApplicationAndroidComponentsExtension androidComponents) {
        if (androidComponents.getPluginVersion().compareTo(new AndroidPluginVersion(8, 1)) < 0) {
            throw new GradleException("The Crashlytics Gradle plugin 3 requires `com.android.application` version 8.1 or above. For more information, see https://firebase.google.com/docs/crashlytics/upgrade-to-crashlytics-gradle-plugin-v3");
        }
    }

    private final void registerExtension(Project project, ApplicationAndroidComponentsExtension androidComponents) {
        androidComponents.registerExtension(new DslExtension.Builder(CRASHLYTICS_EXTENSION_NAME).extendProjectWith(CrashlyticsExtension.class).extendBuildTypeWith(CrashlyticsExtension.class).extendProductFlavorWith(CrashlyticsExtension.class).build(), new Function1<VariantExtensionConfig<?>, VariantExtension>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final VariantExtension invoke(@NotNull VariantExtensionConfig<?> config) {
                Intrinsics.checkNotNullParameter(config, (String)"config");
                Object[] objectArray = new Object[]{config};
                Object object = this.$project.getObjects().newInstance(CrashlyticsVariantExtension.class, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.objects.newInsta\u2026sion::class.java, config)");
                return (VariantExtension)object;
            }
        });
    }

    private final void registerTasks(Project project, ApplicationAndroidComponentsExtension androidComponents) {
        AndroidComponentsExtension.onVariants$default((AndroidComponentsExtension)((AndroidComponentsExtension)androidComponents), null, (Function1)((Function1)new Function1<ApplicationVariant, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull ApplicationVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                CrashlyticsVariantExtension crashlyticsVariantExtension = (CrashlyticsVariantExtension)variant.getExtension(CrashlyticsVariantExtension.class);
                if (crashlyticsVariantExtension == null) {
                    Object object = this.$project.getObjects().newInstance(CrashlyticsVariantExtension.class, new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.objects.newInsta\u2026antExtension::class.java)");
                    crashlyticsVariantExtension = (CrashlyticsVariantExtension)object;
                }
                CrashlyticsVariantExtension crashlyticsExtension = crashlyticsVariantExtension;
                TaskProvider<InjectMappingFileIdTask> injectMappingFileIdTask = InjectMappingFileIdTask.Companion.register(this.$project, (Variant)variant);
                Object object = crashlyticsExtension.getMappingFileUploadEnabled().getOrElse((Object)true);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"crashlyticsExtension.map\u2026adEnabled.getOrElse(true)");
                if (((Boolean)object).booleanValue()) {
                    UploadMappingFileTask.Companion.register(this.$project, (Variant)variant, injectMappingFileIdTask);
                }
                Object object2 = crashlyticsExtension.getNativeSymbolUploadEnabled().getOrElse((Object)false);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"crashlyticsExtension.nat\u2026dEnabled.getOrElse(false)");
                if (((Boolean)object2).booleanValue()) {
                    TaskProvider<GenerateSymbolFileTask> generateSymbolFileTask = GenerateSymbolFileTask.Companion.register(this.$project, (Variant)variant, crashlyticsExtension);
                    UploadSymbolFileTask.Companion.register(this.$project, (Variant)variant, generateSymbolFileTask);
                    InjectBuildIdsTask.Companion.register(this.$project, (Variant)variant);
                }
            }
        }), (int)1, null);
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$validateDependencies(CrashlyticsPlugin $this, ApplicationAndroidComponentsExtension androidComponents) {
        $this.validateDependencies(androidComponents);
    }

    public static final /* synthetic */ void access$registerExtension(CrashlyticsPlugin $this, Project project, ApplicationAndroidComponentsExtension androidComponents) {
        $this.registerExtension(project, androidComponents);
    }

    public static final /* synthetic */ void access$registerTasks(CrashlyticsPlugin $this, Project project, ApplicationAndroidComponentsExtension androidComponents) {
        $this.registerTasks(project, androidComponents);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0004J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/CrashlyticsPlugin$Companion;", "", "()V", "CRASHLYTICS_EXTENSION_NAME", "", "CRASHLYTICS_TASK_GROUP", "UPGRADE_MSG", "buildDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "dirName", "buildFile", "Lorg/gradle/api/file/RegularFile;", "fileName", "crashlytics-gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<Directory> buildDir(@NotNull Project project, @NotNull Variant variant, @NotNull String dirName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
            Provider provider2 = project.getLayout().getBuildDirectory().dir("crashlytics/" + variant.getName() + "/" + dirName);
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.layout.buildDire\u2026{variant.name}/$dirName\")");
            return provider2;
        }

        public static /* synthetic */ Provider buildDir$default(Companion companion, Project project, Variant variant, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            return companion.buildDir(project, variant, string);
        }

        @NotNull
        public final Provider<RegularFile> buildFile(@NotNull Project project, @NotNull Variant variant, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Provider provider2 = project.getLayout().getBuildDirectory().file("crashlytics/" + variant.getName() + "/" + fileName);
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.layout.buildDire\u2026variant.name}/$fileName\")");
            return provider2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

