/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsBuildtools;
import com.google.firebase.crashlytics.buildtools.gradle.extensions.StringExtensionsKt;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.InjectBuildIdsTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectBuildIdsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "mergedNativeLibsDirs", "Lorg/gradle/api/file/DirectoryProperty;", "getMergedNativeLibsDirs", "()Lorg/gradle/api/file/DirectoryProperty;", "resourceDir", "getResourceDir", "injectBuildIds", "", "printDebugProperties", "Companion", "crashlytics-gradle"})
public abstract class InjectBuildIdsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public InjectBuildIdsTask() {
        this.setGroup("Firebase Crashlytics");
        this.setDescription("Adds the mappingFileId as a String resource to the project's Android resource (XML) file.");
    }

    @InputDirectory
    @SkipWhenEmpty
    @NotNull
    public abstract DirectoryProperty getMergedNativeLibsDirs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResourceDir();

    @TaskAction
    public final void injectBuildIds() {
        File file = ((Directory)this.getMergedNativeLibsDirs().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"mergedNativeLibsDirs.get().asFile");
        CrashlyticsBuildtools.INSTANCE.injectBuildIdsIntoResource(file, new File(((Directory)this.getResourceDir().get()).getAsFile(), "values/com_google_firebase_crashlytics_build_ids.xml"));
    }

    private final void printDebugProperties() {
        Object object;
        Object object2;
        this.getLogger().debug("InjectBuildIdsTask:");
        this.getLogger().debug("  mergedNativeLibsDirs: " + ((object2 = (Directory)this.getMergedNativeLibsDirs().getOrNull()) != null && (object2 = object2.getAsFile()) != null ? ((File)object2).getPath() : null));
        this.getLogger().debug("  resourceDir: " + ((object = (Directory)this.getResourceDir().getOrNull()) != null && (object = object.getAsFile()) != null ? ((File)object).getPath() : null));
    }

    public static final /* synthetic */ void access$printDebugProperties(InjectBuildIdsTask $this) {
        $this.printDebugProperties();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectBuildIdsTask$Companion;", "", "()V", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectBuildIdsTask;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "crashlytics-gradle"})
    @SourceDebugExtension(value={"SMAP\nInjectBuildIdsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectBuildIdsTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectBuildIdsTask$Companion\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,78:1\n254#2:79\n*S KotlinDebug\n*F\n+ 1 InjectBuildIdsTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectBuildIdsTask$Companion\n*L\n59#1:79\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<InjectBuildIdsTask> register(@NotNull Project project, @NotNull Variant variant) {
            TaskProvider provider2;
            block0: {
                void name$iv;
                void $this$register$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                TaskContainer taskContainer = project.getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                TaskContainer taskContainer2 = taskContainer;
                String string = "injectCrashlyticsBuildIds" + StringExtensionsKt.capitalized(variant.getName());
                Function1 configuration$iv = (Function1)new Function1<InjectBuildIdsTask, Unit>(variant){
                    final /* synthetic */ Variant $variant;
                    {
                        this.$variant = $variant;
                        super(1);
                    }

                    public final void invoke(@NotNull InjectBuildIdsTask $this$register) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                        $this$register.getMergedNativeLibsDirs().set(this.$variant.getArtifacts().get((SingleArtifact)SingleArtifact.MERGED_NATIVE_LIBS.INSTANCE));
                        InjectBuildIdsTask.access$printDebugProperties($this$register);
                    }
                };
                boolean $i$f$register = false;
                Function1 function1 = configuration$iv;
                TaskProvider taskProvider = $this$register$iv.register((String)name$iv, InjectBuildIdsTask.class, new Action(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ void execute(Object p0) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
                provider2 = taskProvider;
                SourceDirectories.Layered layered = variant.getSources().getRes();
                if (layered == null) break block0;
                layered.addGeneratedSourceDirectory(provider2, (Function1)register.1.INSTANCE);
            }
            return provider2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

