/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle.tasks;

import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsBuildtools;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsPlugin;
import com.google.firebase.crashlytics.buildtools.gradle.extensions.StringExtensionsKt;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.InjectMappingFileIdTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask;", "Lorg/gradle/api/DefaultTask;", "()V", "mappingFileIdFile", "Lorg/gradle/api/file/RegularFileProperty;", "getMappingFileIdFile", "()Lorg/gradle/api/file/RegularFileProperty;", "resourceDir", "Lorg/gradle/api/file/DirectoryProperty;", "getResourceDir", "()Lorg/gradle/api/file/DirectoryProperty;", "sourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSourceFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "injectMappingFileId", "", "Companion", "crashlytics-gradle"})
public abstract class InjectMappingFileIdTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public InjectMappingFileIdTask() {
        this.setGroup("Firebase Crashlytics");
        this.setDescription("Generates and injects a mapping file id into the app, used by Crashlytics for deobfuscation.");
    }

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getSourceFiles();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getMappingFileIdFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResourceDir();

    @TaskAction
    public final void injectMappingFileId() {
        String mappingFileId = CrashlyticsBuildtools.INSTANCE.generateMappingFileId();
        File file = ((RegularFile)this.getMappingFileIdFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"mappingFileIdFile.get().asFile");
        FilesKt.writeText$default((File)file, (String)mappingFileId, null, (int)2, null);
        CrashlyticsBuildtools.INSTANCE.injectMappingFileIdIntoResource(new File(((Directory)this.getResourceDir().get()).getAsFile(), "values/com_google_firebase_crashlytics_mappingfileid.xml"), mappingFileId);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask$Companion;", "", "()V", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "crashlytics-gradle"})
    @SourceDebugExtension(value={"SMAP\nInjectMappingFileIdTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectMappingFileIdTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask$Companion\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,82:1\n254#2:83\n*S KotlinDebug\n*F\n+ 1 InjectMappingFileIdTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask$Companion\n*L\n65#1:83\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<InjectMappingFileIdTask> register(@NotNull Project project, @NotNull Variant variant) {
            TaskProvider injectMappingFileIdTaskProvider2;
            block0: {
                void name$iv;
                void $this$register$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                TaskContainer taskContainer = project.getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                TaskContainer taskContainer2 = taskContainer;
                String string = "injectCrashlyticsMappingFileId" + StringExtensionsKt.capitalized(variant.getName());
                Function1 configuration$iv = (Function1)new Function1<InjectMappingFileIdTask, Unit>(variant, project){
                    final /* synthetic */ Variant $variant;
                    final /* synthetic */ Project $project;
                    {
                        this.$variant = $variant;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull InjectMappingFileIdTask $this$register) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                        Object[] objectArray = new Object[2];
                        SourceDirectories.Flat flat = this.$variant.getSources().getJava();
                        objectArray[0] = flat != null ? flat.getAll() : null;
                        SourceDirectories.Flat flat2 = this.$variant.getSources().getKotlin();
                        objectArray[1] = flat2 != null ? flat2.getAll() : null;
                        $this$register.getSourceFiles().from(objectArray);
                        $this$register.getMappingFileIdFile().set(CrashlyticsPlugin.Companion.buildFile(this.$project, this.$variant, "mappingFileId.txt"));
                    }
                };
                boolean $i$f$register = false;
                Function1 function1 = configuration$iv;
                TaskProvider taskProvider = $this$register$iv.register((String)name$iv, InjectMappingFileIdTask.class, new Action(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ void execute(Object p0) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
                injectMappingFileIdTaskProvider2 = taskProvider;
                SourceDirectories.Layered layered = variant.getSources().getRes();
                if (layered == null) break block0;
                layered.addGeneratedSourceDirectory(injectMappingFileIdTaskProvider2, (Function1)register.1.INSTANCE);
            }
            return injectMappingFileIdTaskProvider2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

