/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.Variant;
import com.google.firebase.crashlytics.buildtools.AppBuildInfo;
import com.google.firebase.crashlytics.buildtools.Obfuscator;
import com.google.firebase.crashlytics.buildtools.exception.ZeroByteFileException;
import com.google.firebase.crashlytics.buildtools.gradle.AppIdFetcher;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsBuildtools;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsPlugin;
import com.google.firebase.crashlytics.buildtools.gradle.extensions.StringExtensionsKt;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.InjectMappingFileIdTask;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.UploadMappingFileTask;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadMappingFileTask;", "Lorg/gradle/api/DefaultTask;", "()V", "appIdFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAppIdFile", "()Lorg/gradle/api/file/RegularFileProperty;", "buildDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildDir", "()Lorg/gradle/api/file/DirectoryProperty;", "mappingFileIdFile", "getMappingFileIdFile", "mergedMappingFile", "getMergedMappingFile", "printDebugProperties", "", "uploadMappingFile", "()Lkotlin/Unit;", "Companion", "crashlytics-gradle"})
public abstract class UploadMappingFileTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public UploadMappingFileTask() {
        this.setGroup("Firebase Crashlytics");
        this.setDescription("Uploads mapping files to Crashlytics for crash deobfuscation.");
    }

    @InputFile
    @SkipWhenEmpty
    @NotNull
    public abstract RegularFileProperty getMergedMappingFile();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getMappingFileIdFile();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getAppIdFile();

    @Internal
    @NotNull
    public abstract DirectoryProperty getBuildDir();

    @TaskAction
    @Nullable
    public final Unit uploadMappingFile() {
        Unit unit;
        try {
            File file = ((RegularFile)this.getAppIdFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"appIdFile.get().asFile");
            String appId = FilesKt.readText$default((File)file, null, (int)1, null);
            File mappingFile = ((RegularFile)this.getMergedMappingFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)mappingFile, (String)"mappingFile");
            File file2 = ((RegularFile)this.getMappingFileIdFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"mappingFileIdFile.get().asFile");
            unit = CrashlyticsBuildtools.INSTANCE.uploadMappingFile(mappingFile, FilesKt.readText$default((File)file2, null, (int)1, null), new AppBuildInfo("", appId, ((Directory)this.getBuildDir().get()).getAsFile()), new Obfuscator(Obfuscator.Vendor.PROGUARD, "0.0"));
        }
        catch (ZeroByteFileException ex) {
            this.getLogger().warn(ex.getMessage(), (Object)"(Use -Pcom.google.firebase.crashlytics.suppressWarnings=true to suppress this warning)");
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    private final void printDebugProperties() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.getLogger().debug("UploadMappingFileTask:");
        this.getLogger().debug("  mergedMappingFile: " + ((object4 = (RegularFile)this.getMergedMappingFile().getOrNull()) != null && (object4 = object4.getAsFile()) != null ? ((File)object4).getPath() : null));
        this.getLogger().debug("  mappingFileIdFile: " + ((object3 = (RegularFile)this.getMappingFileIdFile().getOrNull()) != null && (object3 = object3.getAsFile()) != null ? ((File)object3).getPath() : null));
        this.getLogger().debug("  appIdFile: " + ((object2 = (RegularFile)this.getAppIdFile().getOrNull()) != null && (object2 = object2.getAsFile()) != null ? ((File)object2).getPath() : null));
        this.getLogger().debug("  buildDir: " + ((object = (Directory)this.getBuildDir().getOrNull()) != null && (object = object.getAsFile()) != null ? ((File)object).getPath() : null));
    }

    public static final /* synthetic */ void access$printDebugProperties(UploadMappingFileTask $this) {
        $this.printDebugProperties();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a8\u0006\f"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadMappingFileTask$Companion;", "", "()V", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadMappingFileTask;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "injectMappingFileIdTask", "Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/InjectMappingFileIdTask;", "crashlytics-gradle"})
    @SourceDebugExtension(value={"SMAP\nUploadMappingFileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadMappingFileTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadMappingFileTask$Companion\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,110:1\n254#2:111\n*S KotlinDebug\n*F\n+ 1 UploadMappingFileTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadMappingFileTask$Companion\n*L\n79#1:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<UploadMappingFileTask> register(@NotNull Project project, @NotNull Variant variant, @NotNull TaskProvider<InjectMappingFileIdTask> injectMappingFileIdTask) {
            void name$iv;
            void $this$register$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter(injectMappingFileIdTask, (String)"injectMappingFileIdTask");
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            TaskContainer taskContainer2 = taskContainer;
            String string = "uploadCrashlyticsMappingFile" + StringExtensionsKt.capitalized(variant.getName());
            Function1 configuration$iv = (Function1)new Function1<UploadMappingFileTask, Unit>(variant, injectMappingFileIdTask, project){
                final /* synthetic */ Variant $variant;
                final /* synthetic */ TaskProvider<InjectMappingFileIdTask> $injectMappingFileIdTask;
                final /* synthetic */ Project $project;
                {
                    this.$variant = $variant;
                    this.$injectMappingFileIdTask = $injectMappingFileIdTask;
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(@NotNull UploadMappingFileTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    $this$register.getMergedMappingFile().set(this.$variant.getArtifacts().get((SingleArtifact)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE));
                    $this$register.getMappingFileIdFile().set(this.$injectMappingFileIdTask.flatMap(arg_0 -> register.uploadMappingFileTaskProvider.1.invoke$lambda$0(Companion.register.uploadMappingFileTaskProvider.1.INSTANCE, arg_0)));
                    $this$register.getAppIdFile().set(AppIdFetcher.INSTANCE.getGoogleServicesAppId(this.$project, this.$variant));
                    $this$register.getBuildDir().set(CrashlyticsPlugin.Companion.buildDir$default(CrashlyticsPlugin.Companion, this.$project, this.$variant, null, 4, null));
                    UploadMappingFileTask.access$printDebugProperties($this$register);
                }

                private static final Provider invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Provider)$tmp0.invoke(p0);
                }
            };
            boolean $i$f$register = false;
            Function1 function1 = configuration$iv;
            TaskProvider taskProvider = $this$register$iv.register((String)name$iv, UploadMappingFileTask.class, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void execute(Object p0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
            TaskProvider uploadMappingFileTaskProvider2 = taskProvider;
            project.afterEvaluate(arg_0 -> Companion.register$lambda$0((Function1)new Function1<Project, Unit>(variant, (TaskProvider<UploadMappingFileTask>)uploadMappingFileTaskProvider2){
                final /* synthetic */ Variant $variant;
                final /* synthetic */ TaskProvider<UploadMappingFileTask> $uploadMappingFileTaskProvider;
                {
                    this.$variant = $variant;
                    this.$uploadMappingFileTaskProvider = $uploadMappingFileTaskProvider;
                    super(1);
                }

                public final void invoke(Project it) {
                    Task task = it.getTasks().findByPath("minify" + StringExtensionsKt.capitalized(this.$variant.getName()) + "WithR8");
                    if (task != null) {
                        Object[] objectArray = new Object[]{this.$uploadMappingFileTaskProvider};
                        task.finalizedBy(objectArray);
                    }
                }
            }, arg_0));
            return uploadMappingFileTaskProvider2;
        }

        private static final void register$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

