/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle.tasks;

import com.android.build.api.variant.Variant;
import com.google.firebase.crashlytics.buildtools.api.SymbolFileService;
import com.google.firebase.crashlytics.buildtools.gradle.AppIdFetcher;
import com.google.firebase.crashlytics.buildtools.gradle.CrashlyticsBuildtools;
import com.google.firebase.crashlytics.buildtools.gradle.SymbolGeneratorType;
import com.google.firebase.crashlytics.buildtools.gradle.extensions.StringExtensionsKt;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.GenerateSymbolFileTask;
import com.google.firebase.crashlytics.buildtools.gradle.tasks.UploadSymbolFileTask;
import com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad.BreakpadSymbolFileService;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CsymSymbolFileService;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadSymbolFileTask;", "Lorg/gradle/api/DefaultTask;", "()V", "appIdFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAppIdFile", "()Lorg/gradle/api/file/RegularFileProperty;", "symbolFileDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getSymbolFileDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "symbolGeneratorType", "Lorg/gradle/api/provider/Property;", "Lcom/google/firebase/crashlytics/buildtools/gradle/SymbolGeneratorType;", "getSymbolGeneratorType", "()Lorg/gradle/api/provider/Property;", "printDebugProperties", "", "uploadSymbolFiles", "Companion", "crashlytics-gradle"})
public abstract class UploadSymbolFileTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public UploadSymbolFileTask() {
        this.setGroup("Firebase Crashlytics");
        this.setDescription("Upload native (NDK) symbol files to Crashlytics to symbolicate stack traces");
    }

    @InputDirectory
    @SkipWhenEmpty
    @NotNull
    public abstract DirectoryProperty getSymbolFileDirectory();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getAppIdFile();

    @Internal
    @NotNull
    public abstract Property<SymbolGeneratorType> getSymbolGeneratorType();

    @TaskAction
    public final void uploadSymbolFiles() {
        File file = ((RegularFile)this.getAppIdFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"appIdFile.get().asFile");
        String appId = FilesKt.readText$default((File)file, null, (int)1, null);
        Object object = this.getSymbolGeneratorType().get();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.firebase.crashlytics.buildtools.gradle.SymbolGeneratorType");
        SymbolFileService symbolFileService = switch (WhenMappings.$EnumSwitchMapping$0[((SymbolGeneratorType)((Object)object)).ordinal()]) {
            case 1 -> new BreakpadSymbolFileService();
            case 2 -> new CsymSymbolFileService();
            default -> throw new NoWhenBranchMatchedException();
        };
        File file2 = ((Directory)this.getSymbolFileDirectory().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"symbolFileDirectory.get().asFile");
        CrashlyticsBuildtools.INSTANCE.uploadNativeSymbolFiles(file2, appId, symbolFileService);
    }

    private final void printDebugProperties() {
        Object object;
        Object object2;
        this.getLogger().debug("UploadSymbolFileTask:");
        this.getLogger().debug("  mergedMappingFile: " + ((object2 = (Directory)this.getSymbolFileDirectory().getOrNull()) != null && (object2 = object2.getAsFile()) != null ? ((File)object2).getPath() : null));
        this.getLogger().debug("  appIdFile: " + ((object = (RegularFile)this.getAppIdFile().getOrNull()) != null && (object = object.getAsFile()) != null ? ((File)object).getPath() : null));
        SymbolGeneratorType symbolGeneratorType = (SymbolGeneratorType)((Object)this.getSymbolGeneratorType().getOrNull());
        this.getLogger().debug("  symbolGeneratorType: " + (symbolGeneratorType != null ? symbolGeneratorType.toString() : null));
    }

    public static final /* synthetic */ void access$printDebugProperties(UploadSymbolFileTask $this) {
        $this.printDebugProperties();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SymbolGeneratorType.values().length];
            try {
                nArray[SymbolGeneratorType.BREAKPAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SymbolGeneratorType.CSYM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a8\u0006\f"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadSymbolFileTask$Companion;", "", "()V", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadSymbolFileTask;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "generateSymbolFileTask", "Lcom/google/firebase/crashlytics/buildtools/gradle/tasks/GenerateSymbolFileTask;", "crashlytics-gradle"})
    @SourceDebugExtension(value={"SMAP\nUploadSymbolFileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadSymbolFileTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadSymbolFileTask$Companion\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,93:1\n254#2:94\n*S KotlinDebug\n*F\n+ 1 UploadSymbolFileTask.kt\ncom/google/firebase/crashlytics/buildtools/gradle/tasks/UploadSymbolFileTask$Companion\n*L\n75#1:94\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<UploadSymbolFileTask> register(@NotNull Project project, @NotNull Variant variant, @NotNull TaskProvider<GenerateSymbolFileTask> generateSymbolFileTask) {
            void name$iv;
            void $this$register$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter(generateSymbolFileTask, (String)"generateSymbolFileTask");
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            TaskContainer taskContainer2 = taskContainer;
            String string = "uploadCrashlyticsSymbolFile" + StringExtensionsKt.capitalized(variant.getName());
            Function1 configuration$iv = (Function1)new Function1<UploadSymbolFileTask, Unit>(generateSymbolFileTask, project, variant){
                final /* synthetic */ TaskProvider<GenerateSymbolFileTask> $generateSymbolFileTask;
                final /* synthetic */ Project $project;
                final /* synthetic */ Variant $variant;
                {
                    this.$generateSymbolFileTask = $generateSymbolFileTask;
                    this.$project = $project;
                    this.$variant = $variant;
                    super(1);
                }

                public final void invoke(@NotNull UploadSymbolFileTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    $this$register.getSymbolFileDirectory().set(this.$generateSymbolFileTask.flatMap(arg_0 -> register.1.invoke$lambda$0(Companion.register.1.INSTANCE, arg_0)));
                    $this$register.getAppIdFile().set(AppIdFetcher.INSTANCE.getGoogleServicesAppId(this.$project, this.$variant));
                    $this$register.getSymbolGeneratorType().set(this.$generateSymbolFileTask.flatMap(arg_0 -> register.1.invoke$lambda$1(register.2.INSTANCE, arg_0)));
                    UploadSymbolFileTask.access$printDebugProperties($this$register);
                }

                private static final Provider invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Provider)$tmp0.invoke(p0);
                }

                private static final Provider invoke$lambda$1(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Provider)$tmp0.invoke(p0);
                }
            };
            boolean $i$f$register = false;
            Function1 function1 = configuration$iv;
            TaskProvider taskProvider = $this$register$iv.register((String)name$iv, UploadSymbolFileTask.class, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void execute(Object p0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
            return taskProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

