/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions.settings;

import android.os.Build;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.datastore.core.DataStore;
import androidx.datastore.preferences.core.Preferences;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.ApplicationInfo;
import com.google.firebase.sessions.InstallationId;
import com.google.firebase.sessions.settings.CrashlyticsSettingsFetcher;
import com.google.firebase.sessions.settings.RemoteSettings;
import com.google.firebase.sessions.settings.SettingsCache;
import com.google.firebase.sessions.settings.SettingsProvider;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\r\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u0015H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0011\u0010%\u001a\u00020\u001fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lcom/google/firebase/sessions/settings/RemoteSettings;", "Lcom/google/firebase/sessions/settings/SettingsProvider;", "backgroundDispatcher", "Lkotlin/coroutines/CoroutineContext;", "firebaseInstallationsApi", "Lcom/google/firebase/installations/FirebaseInstallationsApi;", "appInfo", "Lcom/google/firebase/sessions/ApplicationInfo;", "configsFetcher", "Lcom/google/firebase/sessions/settings/CrashlyticsSettingsFetcher;", "dataStore", "Landroidx/datastore/core/DataStore;", "Landroidx/datastore/preferences/core/Preferences;", "(Lkotlin/coroutines/CoroutineContext;Lcom/google/firebase/installations/FirebaseInstallationsApi;Lcom/google/firebase/sessions/ApplicationInfo;Lcom/google/firebase/sessions/settings/CrashlyticsSettingsFetcher;Landroidx/datastore/core/DataStore;)V", "fetchInProgress", "Lkotlinx/coroutines/sync/Mutex;", "samplingRate", "", "getSamplingRate", "()Ljava/lang/Double;", "sessionEnabled", "", "getSessionEnabled", "()Ljava/lang/Boolean;", "sessionRestartTimeout", "Lkotlin/time/Duration;", "getSessionRestartTimeout-FghU774", "()Lkotlin/time/Duration;", "settingsCache", "Lcom/google/firebase/sessions/settings/SettingsCache;", "clearCachedSettings", "", "clearCachedSettings$com_google_firebase_firebase_sessions", "isSettingsStale", "removeForwardSlashesIn", "", "s", "updateSettings", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "com.google.firebase-firebase-sessions"})
@SourceDebugExtension(value={"SMAP\nRemoteSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteSettings.kt\ncom/google/firebase/sessions/settings/RemoteSettings\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,164:1\n107#2,10:165\n*S KotlinDebug\n*F\n+ 1 RemoteSettings.kt\ncom/google/firebase/sessions/settings/RemoteSettings\n*L\n68#1:165,10\n*E\n"})
public final class RemoteSettings
implements SettingsProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineContext backgroundDispatcher;
    @NotNull
    private final FirebaseInstallationsApi firebaseInstallationsApi;
    @NotNull
    private final ApplicationInfo appInfo;
    @NotNull
    private final CrashlyticsSettingsFetcher configsFetcher;
    @NotNull
    private final SettingsCache settingsCache;
    @NotNull
    private final Mutex fetchInProgress;
    @Deprecated
    @NotNull
    public static final String TAG = "SessionConfigFetcher";
    @Deprecated
    @NotNull
    public static final String FORWARD_SLASH_STRING = "/";

    public RemoteSettings(@NotNull CoroutineContext backgroundDispatcher, @NotNull FirebaseInstallationsApi firebaseInstallationsApi, @NotNull ApplicationInfo appInfo, @NotNull CrashlyticsSettingsFetcher configsFetcher, @NotNull DataStore<Preferences> dataStore2) {
        Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
        Intrinsics.checkNotNullParameter((Object)firebaseInstallationsApi, (String)"firebaseInstallationsApi");
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        Intrinsics.checkNotNullParameter((Object)configsFetcher, (String)"configsFetcher");
        Intrinsics.checkNotNullParameter(dataStore2, (String)"dataStore");
        this.backgroundDispatcher = backgroundDispatcher;
        this.firebaseInstallationsApi = firebaseInstallationsApi;
        this.appInfo = appInfo;
        this.configsFetcher = configsFetcher;
        this.settingsCache = new SettingsCache(dataStore2);
        this.fetchInProgress = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @Override
    @Nullable
    public Boolean getSessionEnabled() {
        return this.settingsCache.sessionsEnabled();
    }

    @Override
    @Nullable
    public Duration getSessionRestartTimeout-FghU774() {
        Integer n = this.settingsCache.sessionRestartTimeout();
        return n != null ? Duration.box-impl((long)DurationKt.toDuration((int)n, (DurationUnit)DurationUnit.SECONDS)) : null;
    }

    @Override
    @Nullable
    public Double getSamplingRate() {
        return this.settingsCache.sessionSamplingRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object updateSettings(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof updateSettings.1)) ** GOTO lbl-1000
        var15_2 = var1_1;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteSettings this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateSettings((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.fetchInProgress.isLocked() && !this.settingsCache.hasCacheExpired$com_google_firebase_firebase_sessions()) {
                    return Unit.INSTANCE;
                }
                $this$withLock_u24default$iv = this.fetchInProgress;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (RemoteSettings)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 3 sources

                $i$a$-withLock$default-RemoteSettings$updateSettings$2 = false;
                if (this.settingsCache.hasCacheExpired$com_google_firebase_firebase_sessions()) ** GOTO lbl42
                Log.d((String)"SessionConfigFetcher", (String)"Remote settings cache not expired. Using cached values.");
                var13_14 = Unit.INSTANCE;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var13_14;
lbl42:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 2;
                v1 = InstallationId.Companion.create(this.firebaseInstallationsApi, (Continuation<? super InstallationId>)$continuation);
                ** if (v1 != var16_4) goto lbl48
lbl47:
                // 1 sources

                return var16_4;
lbl48:
                // 1 sources

                ** GOTO lbl59
            }
            case 2: {
                $i$a$-withLock$default-RemoteSettings$updateSettings$2 = false;
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (RemoteSettings)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl59:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(installationId = ((InstallationId)v1).getFid()), (Object)"")) ** GOTO lbl66
                Log.w((String)"SessionConfigFetcher", (String)"Error getting Firebase Installation ID. Skipping this Session Event.");
                var12_16 = Unit.INSTANCE;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var12_16;
lbl66:
                // 2 sources

                var7_17 = new Pair[5];
                var7_17[0] = TuplesKt.to((Object)"X-Crashlytics-Installation-ID", (Object)installationId);
                var8_18 = "%s/%s";
                var9_19 = new Object[]{Build.MANUFACTURER, Build.MODEL};
                v2 = String.format(var8_18, Arrays.copyOf(var9_19, var9_19.length));
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"format(format, *args)");
                var7_17[1] = TuplesKt.to((Object)"X-Crashlytics-Device-Model", (Object)this.removeForwardSlashesIn(v2));
                v3 = Build.VERSION.INCREMENTAL;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"INCREMENTAL");
                var7_17[2] = TuplesKt.to((Object)"X-Crashlytics-OS-Build-Version", (Object)this.removeForwardSlashesIn(v3));
                v4 = Build.VERSION.RELEASE;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"RELEASE");
                var7_17[3] = TuplesKt.to((Object)"X-Crashlytics-OS-Display-Version", (Object)this.removeForwardSlashesIn(v4));
                var7_17[4] = TuplesKt.to((Object)"X-Crashlytics-API-Client-Version", (Object)this.appInfo.getSessionSdkVersion());
                options = MapsKt.mapOf((Pair[])var7_17);
                Log.d((String)"SessionConfigFetcher", (String)"Fetching settings from server.");
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v5 = this.configsFetcher.doConfigFetch(options, (Function2<? super JSONObject, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<JSONObject, Continuation<? super Unit>, Object>(this, null){
                    Object L$1;
                    Object L$2;
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ RemoteSettings this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    it = (JSONObject)this.L$0;
                                                    Log.d((String)"SessionConfigFetcher", (String)("Fetched settings: " + it));
                                                    sessionsEnabled = null;
                                                    sessionSamplingRate = new Ref.ObjectRef();
                                                    sessionTimeoutSeconds = new Ref.ObjectRef();
                                                    cacheDuration = new Ref.ObjectRef();
                                                    if (it.has("app_quality")) {
                                                        var8_8 = it.get("app_quality");
                                                        Intrinsics.checkNotNull((Object)var8_8, (String)"null cannot be cast to non-null type org.json.JSONObject");
                                                        aqsSettings = (JSONObject)var8_8;
                                                        try {
                                                            if (aqsSettings.has("sessions_enabled")) {
                                                                sessionsEnabled = (Boolean)aqsSettings.get("sessions_enabled");
                                                            }
                                                            if (aqsSettings.has("sampling_rate")) {
                                                                sessionSamplingRate.element = (Double)aqsSettings.get("sampling_rate");
                                                            }
                                                            if (aqsSettings.has("session_timeout_seconds")) {
                                                                sessionTimeoutSeconds.element = (Integer)aqsSettings.get("session_timeout_seconds");
                                                            }
                                                            if (aqsSettings.has("cache_duration")) {
                                                                cacheDuration.element = (Integer)aqsSettings.get("cache_duration");
                                                            }
                                                        }
                                                        catch (JSONException exception) {
                                                            Log.e((String)"SessionConfigFetcher", (String)"Error parsing the configs remotely fetched: ", (Throwable)exception);
                                                        }
                                                    }
                                                    v0 = sessionsEnabled;
                                                    if (v0 == null) break;
                                                    var8_8 = v0;
                                                    var9_11 = this.this$0;
                                                    var8_8.booleanValue();
                                                    $i$a$-let-RemoteSettings$updateSettings$2$1$1 = false;
                                                    this.L$0 = sessionSamplingRate;
                                                    this.L$1 = sessionTimeoutSeconds;
                                                    this.L$2 = cacheDuration;
                                                    this.label = 1;
                                                    v1 = RemoteSettings.access$getSettingsCache$p((RemoteSettings)var9_11).updateSettingsEnabled(sessionsEnabled, (Continuation<? super Unit>)this);
                                                    if (v1 == var13_2) {
                                                        return var13_2;
                                                    }
                                                    break;
                                                }
                                                case 1: {
                                                    $i$a$-let-RemoteSettings$updateSettings$2$1$1 = false;
                                                    cacheDuration = (Ref.ObjectRef)this.L$2;
                                                    sessionTimeoutSeconds = (Ref.ObjectRef)this.L$1;
                                                    sessionSamplingRate = (Ref.ObjectRef)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
                                                    break;
                                                }
                                            }
                                            v2 = (Integer)sessionTimeoutSeconds.element;
                                            if (v2 != null) {
                                                var8_8 = v2;
                                                var9_11 = this.this$0;
                                                ((Number)var8_8).intValue();
                                                $i$a$-let-RemoteSettings$updateSettings$2$1$2 = false;
                                                this.L$0 = sessionSamplingRate;
                                                this.L$1 = cacheDuration;
                                                this.L$2 = null;
                                                this.label = 2;
                                                v3 = RemoteSettings.access$getSettingsCache$p((RemoteSettings)var9_11).updateSessionRestartTimeout((Integer)sessionTimeoutSeconds.element, (Continuation<? super Unit>)this);
                                                if (v3 == var13_2) {
                                                    return var13_2;
                                                }
                                            }
                                            break block25;
                                            {
                                                case 2: {
                                                    $i$a$-let-RemoteSettings$updateSettings$2$1$2 = false;
                                                    cacheDuration = (Ref.ObjectRef)this.L$1;
                                                    sessionSamplingRate = (Ref.ObjectRef)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v3 = $result;
                                                }
                                            }
                                        }
                                        v4 = (Double)sessionSamplingRate.element;
                                        if (v4 != null) {
                                            var8_8 = v4;
                                            var9_11 = this.this$0;
                                            ((Number)var8_8).doubleValue();
                                            $i$a$-let-RemoteSettings$updateSettings$2$1$3 = false;
                                            this.L$0 = cacheDuration;
                                            this.L$1 = null;
                                            this.L$2 = null;
                                            this.label = 3;
                                            v5 = RemoteSettings.access$getSettingsCache$p((RemoteSettings)var9_11).updateSamplingRate((Double)sessionSamplingRate.element, (Continuation<? super Unit>)this);
                                            if (v5 == var13_2) {
                                                return var13_2;
                                            }
                                        }
                                        break block26;
                                        {
                                            case 3: {
                                                $i$a$-let-RemoteSettings$updateSettings$2$1$3 = false;
                                                cacheDuration = (Ref.ObjectRef)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v5 = $result;
                                            }
                                        }
                                    }
                                    v6 = (Integer)cacheDuration.element;
                                    if (v6 == null) break block27;
                                    var9_11 = v6;
                                    var10_16 = this.this$0;
                                    ((Number)var9_11).intValue();
                                    $i$a$-let-RemoteSettings$updateSettings$2$1$4 = false;
                                    this.L$0 = null;
                                    this.L$1 = null;
                                    this.L$2 = null;
                                    this.label = 4;
                                    v7 = RemoteSettings.access$getSettingsCache$p(var10_16).updateSessionCacheDuration((Integer)cacheDuration.element, (Continuation<? super Unit>)this);
                                    if (v7 == var13_2) {
                                        return var13_2;
                                    }
                                    ** GOTO lbl122
                                    {
                                        case 4: {
                                            $i$a$-let-RemoteSettings$updateSettings$2$1$4 = false;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v7 = $result;
lbl122:
                                            // 2 sources

                                            v8 = Unit.INSTANCE;
                                            break block28;
                                        }
                                    }
                                }
                                v8 = null;
                            }
                            if (v8 != null) break block29;
                            var8_8 = this.this$0;
                            var9_11 = this.this$0;
                            $i$a$-let-RemoteSettings$updateSettings$2$1$5 = false;
                            this.L$0 = null;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 5;
                            v9 = RemoteSettings.access$getSettingsCache$p((RemoteSettings)var9_11).updateSessionCacheDuration(Boxing.boxInt((int)86400), (Continuation<? super Unit>)this);
                            if (v9 == var13_2) {
                                return var13_2;
                            }
                            break block29;
                            {
                                case 5: {
                                    $i$a$-let-RemoteSettings$updateSettings$2$1$5 = false;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v9 = $result;
                                    break;
                                }
                            }
                        }
                        this.L$0 = null;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 6;
                        v10 = RemoteSettings.access$getSettingsCache$p(this.this$0).updateSessionCacheUpdatedTime(Boxing.boxLong((long)System.currentTimeMillis()), (Continuation<? super Unit>)((Continuation)this));
                        if (v10 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl156
                        {
                            case 6: {
                                ResultKt.throwOnFailure((Object)$result);
                                v10 = $result;
lbl156:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<JSONObject, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull JSONObject p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Function2<? super String, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<String, Continuation<? super Unit>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                String msg = (String)this.L$0;
                                Log.e((String)"SessionConfigFetcher", (String)("Error failing to fetch the remote configs: " + msg));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<String, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull String p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)$continuation);
                ** if (v5 != var16_4) goto lbl90
lbl89:
                // 1 sources

                return var16_4;
lbl90:
                // 1 sources

                ** GOTO lbl100
            }
            case 3: {
                $i$a$-withLock$default-RemoteSettings$updateSettings$2 = false;
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl100:
                    // 2 sources

                    var11_21 = Unit.INSTANCE;
                }
                catch (Throwable var11_22) {
                    throw var11_22;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean isSettingsStale() {
        return this.settingsCache.hasCacheExpired$com_google_firebase_firebase_sessions();
    }

    @VisibleForTesting
    public final void clearCachedSettings$com_google_firebase_firebase_sessions() {
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.backgroundDispatcher);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RemoteSettings this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = RemoteSettings.access$getSettingsCache$p(this.this$0).removeConfigs$com_google_firebase_firebase_sessions((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final String removeForwardSlashesIn(String s) {
        CharSequence charSequence = s;
        Regex regex = new Regex(FORWARD_SLASH_STRING);
        String string = "";
        return regex.replace(charSequence, string);
    }

    public static final /* synthetic */ SettingsCache access$getSettingsCache$p(RemoteSettings $this) {
        return $this.settingsCache;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/google/firebase/sessions/settings/RemoteSettings$Companion;", "", "()V", "FORWARD_SLASH_STRING", "", "TAG", "com.google.firebase-firebase-sessions"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

