/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.AppExtension;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.instrumentation.Instrument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirebaseTransform
extends Transform {
    private final Project mProject;
    private final Logger mLogger;
    private final Set<QualifiedContent.ContentType> mTypeClasses;
    private final Set<QualifiedContent.Scope> mScopes;
    private AppExtension mAppExt;
    private Instrument mInstrumentation;
    private boolean mIsInstrumentationEnabled = true;
    private Map<String, Object> mParams;
    public static final String FIREBASE_PERF_TAG = "FirebasePerformancePlugin";
    public static final String FIREBASE_PERF = "FirebasePerformance";
    private static final String FIREBASE_PERF_INSTRUMENTATION_ENABLED = "firebasePerformanceInstrumentationEnabled";

    public FirebaseTransform(Project project) {
        this.mProject = project;
        this.mLogger = LoggerFactory.getLogger((String)FIREBASE_PERF_TAG);
        this.mTypeClasses = Sets.newHashSet();
        this.mTypeClasses.add((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES);
        this.mScopes = ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.SUB_PROJECTS);
        this.mParams = new HashMap<String, Object>();
        this.mParams.put(FIREBASE_PERF_INSTRUMENTATION_ENABLED, this.mIsInstrumentationEnabled);
    }

    public String getName() {
        return FIREBASE_PERF_TAG;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.mTypeClasses;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return this.mScopes;
    }

    public boolean isIncremental() {
        return true;
    }

    public Map<String, Object> getParameterInputs() {
        try {
            boolean fpExtVal;
            FirebasePerfExtension perfExt = (FirebasePerfExtension)this.mProject.getExtensions().findByName(FIREBASE_PERF);
            if (this.mProject.hasProperty(FIREBASE_PERF_INSTRUMENTATION_ENABLED)) {
                boolean value = Boolean.parseBoolean(this.mProject.property(FIREBASE_PERF_INSTRUMENTATION_ENABLED).toString());
                if (!value) {
                    this.mProject.getLogger().info("Firebase Performance Instrumentation is disabled");
                    this.mIsInstrumentationEnabled = false;
                }
            } else if (perfExt != null && perfExt instanceof FirebasePerfExtension && !(fpExtVal = perfExt.isInstrumentationEnabled())) {
                this.mProject.getLogger().info("Firebase Performance Instrumentation is disabled");
                this.mIsInstrumentationEnabled = false;
            }
            if (this.mIsInstrumentationEnabled) {
                this.mProject.getLogger().info("Firebase Performance Instrumentation is enabled");
                this.mIsInstrumentationEnabled = true;
            }
            this.mParams.put(FIREBASE_PERF_INSTRUMENTATION_ENABLED, this.mIsInstrumentationEnabled);
            return this.mParams;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void transform(TransformInvocation invocation) throws TransformException, IOException {
        Collection inputs = invocation.getInputs();
        Collection referencedInputs = invocation.getReferencedInputs();
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        boolean incremental = invocation.isIncremental();
        this.mAppExt = (AppExtension)this.mProject.getExtensions().findByName("android");
        List<URL> runtimeCP = this.buildRuntimeClasspath(inputs, referencedInputs);
        this.mLogger.debug("Effective app classpath at runtime:");
        for (URL url : runtimeCP) {
            String string = String.valueOf(url.toString());
            this.mLogger.debug(string.length() != 0 ? "- ".concat(string) : new String("- "));
        }
        try (URLClassLoader cl = new URLClassLoader(runtimeCP.toArray(new URL[runtimeCP.size()]), null);){
            this.mLogger.info(new StringBuilder(36).append("Transforming with incremental: ").append(incremental).toString());
            if (!incremental) {
                outputProvider.deleteAll();
            }
            this.mInstrumentation = new Instrument(cl);
            for (TransformInput ti : inputs) {
                this.transformDirectoryInputs(ti, incremental, outputProvider);
                this.transformJarInputs(ti, incremental, outputProvider);
            }
        }
    }

    private void transformJarInputs(TransformInput ti, boolean incremental, TransformOutputProvider outputProvider) throws IOException {
        for (JarInput ji : ti.getJarInputs()) {
            boolean doXForm;
            String uniqueName;
            String string;
            String string2;
            String string3 = String.valueOf(ji);
            this.mLogger.debug(new StringBuilder(19 + String.valueOf(string3).length()).append("TransformInput jar ").append(string3).toString());
            File jar = ji.getFile();
            String jarName = jar.getName();
            int lastIndex = jarName.lastIndexOf(46);
            if (lastIndex != -1) {
                string2 = DigestUtils.md5Hex((String)jar.getPath());
                string = jarName.substring(0, lastIndex);
                uniqueName = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append("-").append(string).toString();
            } else {
                string2 = DigestUtils.md5Hex((String)jar.getPath());
                uniqueName = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(jarName).length()).append(string2).append("-").append(jarName).toString();
            }
            File outDir = outputProvider.getContentLocation(uniqueName, ji.getContentTypes(), ji.getScopes(), Format.DIRECTORY);
            string = String.valueOf(ji.getFile());
            this.mLogger.debug(new StringBuilder(12 + String.valueOf(string).length()).append("  Jar input ").append(string).toString());
            string = String.valueOf(outDir);
            this.mLogger.debug(new StringBuilder(19 + String.valueOf(string).length()).append("  Directory output ").append(string).toString());
            boolean bl = doXForm = !incremental || ji.getStatus() == Status.ADDED || ji.getStatus() == Status.CHANGED;
            if (doXForm) {
                if (this.mIsInstrumentationEnabled) {
                    if (!outDir.mkdirs() && !outDir.isDirectory()) continue;
                    this.mInstrumentation.instrumentClassesInJar(jar, outDir);
                    continue;
                }
                File outJar = outputProvider.getContentLocation(uniqueName, ji.getContentTypes(), ji.getScopes(), Format.JAR);
                if (outJar.getParentFile().mkdirs() || outJar.getParentFile().isDirectory()) {
                    FileInputStream fis = new FileInputStream(ji.getFile());
                    Throwable throwable = null;
                    try {
                        FileOutputStream fos = new FileOutputStream(outJar);
                        Throwable throwable2 = null;
                        try {
                            IOUtils.copy((InputStream)fis, (OutputStream)fos);
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            FirebaseTransform.$closeResource(throwable2, fos);
                            continue;
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        FirebaseTransform.$closeResource(throwable, fis);
                        continue;
                    }
                }
                String string4 = String.valueOf(outDir);
                throw new IOException(new StringBuilder(36 + String.valueOf(string4).length()).append("Couldn't create transformExt output ").append(string4).toString());
            }
            if (ji.getStatus() == Status.REMOVED) {
                FileUtils.deleteQuietly((File)outDir);
                continue;
            }
            String string5 = String.valueOf(ji.getFile());
            this.mLogger.debug(new StringBuilder(22 + String.valueOf(string5).length()).append("Skipping transformExt ").append(string5).toString());
        }
    }

    private void transformDirectoryInputs(TransformInput ti, boolean incremental, TransformOutputProvider outputProvider) throws IOException {
        for (DirectoryInput di : ti.getDirectoryInputs()) {
            String string = String.valueOf(di);
            this.mLogger.debug(new StringBuilder(19 + String.valueOf(string).length()).append("TransformInput dir ").append(string).toString());
            String uniqueName = DigestUtils.md5Hex((String)di.getFile().getPath());
            File outDir = outputProvider.getContentLocation(uniqueName, di.getContentTypes(), di.getScopes(), Format.DIRECTORY);
            String string2 = String.valueOf(di.getFile());
            this.mLogger.debug(new StringBuilder(18 + String.valueOf(string2).length()).append("  Directory input ").append(string2).toString());
            String string3 = String.valueOf(di.getFile().getName());
            this.mLogger.debug(string3.length() != 0 ? "files: ".concat(string3) : new String("files: "));
            string2 = String.valueOf(outDir);
            this.mLogger.debug(new StringBuilder(19 + String.valueOf(string2).length()).append("  Directory output ").append(string2).toString());
            Map changed = null;
            if (incremental) {
                changed = di.getChangedFiles();
            }
            if (!outDir.mkdirs() && !outDir.isDirectory()) continue;
            if (this.mIsInstrumentationEnabled) {
                this.mInstrumentation.instrumentClassesInDir(di.getFile(), 0, String.valueOf(outDir.toString()).concat("/"), changed);
                continue;
            }
            FileUtils.deleteDirectory((File)outDir);
            FileUtils.moveDirectory((File)di.getFile(), (File)outDir);
        }
    }

    private List<URL> buildRuntimeClasspath(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs) {
        ArrayList<File> cp = new ArrayList<File>();
        cp.addAll(this.mAppExt.getBootClasspath());
        for (Collection tis : Arrays.asList(inputs, referencedInputs)) {
            for (TransformInput ti : tis) {
                List<Collection> allQC = Arrays.asList(ti.getDirectoryInputs(), ti.getJarInputs());
                for (Collection qcs : allQC) {
                    for (QualifiedContent qc : qcs) {
                        cp.add(qc.getFile());
                    }
                }
            }
        }
        return Lists.transform(cp, (Function)new Function<File, URL>(){

            public URL apply(File file) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    String string = String.valueOf(file);
                    FirebaseTransform.this.mLogger.error(new StringBuilder(42 + String.valueOf(string).length()).append("Unable to instrument classes due to file: ").append(string).toString());
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

