/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfigBuilder;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.annotation.FirebaseTimerAnnotationConfig;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.network.config.HttpClientExecuteHostRequestContextIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.HttpClientExecuteHostRequestHandlerContextIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.HttpClientExecuteHostRequestHandlerIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.HttpClientExecuteHostRequestIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.HttpClientExecuteRequestContextIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.HttpClientExecuteRequestHandlerContextIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.HttpClientExecuteRequestHandlerIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.HttpClientExecuteRequestIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.OkHttpClientCallEnqueueIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.OkHttpClientCallExecuteIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.UrlConnectionGetContentClassIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.UrlConnectionGetContentIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.UrlConnectionOpenConnectionIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.UrlConnectionOpenConnectionProxyIC;
import com.google.firebase.perf.plugin.instrumentation.network.config.UrlConnectionOpenStreamIC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationConfigFactory {
    private static final Logger mLogger = LoggerFactory.getLogger((String)"InstrumentationConfigFactory");
    private final AnnotatedMethodInstrumentationConfig[] mAnnotationConfigs = new AnnotatedMethodInstrumentationConfig[]{new FirebaseTimerAnnotationConfig()};
    private final ClassLoader mClassLoader;
    private final NetworkObjectInstrumentationConfig[] mNetworkConfigs = new NetworkObjectInstrumentationConfig[]{new UrlConnectionOpenConnectionIC(), new UrlConnectionOpenConnectionProxyIC(), new UrlConnectionOpenStreamIC(), new UrlConnectionGetContentIC(), new UrlConnectionGetContentClassIC(), new HttpClientExecuteRequestIC(), new HttpClientExecuteRequestContextIC(), new HttpClientExecuteRequestHandlerIC(), new HttpClientExecuteRequestHandlerContextIC(), new HttpClientExecuteHostRequestIC(), new HttpClientExecuteHostRequestContextIC(), new HttpClientExecuteHostRequestHandlerIC(), new HttpClientExecuteHostRequestHandlerContextIC(), new OkHttpClientCallExecuteIC(), new OkHttpClientCallEnqueueIC()};

    public InstrumentationConfigFactory(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    public InstrumentationConfig newConfig() {
        InstrumentationConfigBuilder builder = new InstrumentationConfigBuilder();
        for (AnnotatedMethodInstrumentationConfig annotatedMethodInstrumentationConfig : this.mAnnotationConfigs) {
            builder.addAnnotationMethodInstrumentationConfig(annotatedMethodInstrumentationConfig);
        }
        for (NetworkObjectInstrumentationConfig networkObjectInstrumentationConfig : this.mNetworkConfigs) {
            builder.addNetworkObjectInstrumentationConfig(networkObjectInstrumentationConfig);
        }
        builder.setClassLoader(this.mClassLoader);
        return builder.build();
    }
}

