/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation.annotation;

import com.google.firebase.perf.plugin.instrumentation.InstrumentationContext;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodAdapter;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationFactory;
import com.google.firebase.perf.plugin.instrumentation.model.AnnotationInfo;
import com.google.firebase.perf.plugin.sdk.FirebaseTrace;
import org.objectweb.asm.commons.AdviceAdapter;

public class FirebaseTimerAnnotationProcessor
implements AnnotatedMethodAdapter {
    private static final String TIMER_ANNOTATION_ATTR_NAME = "name";
    private static final String TIMER_ANNOTATION_ATTR_ENABLED = "enabled";
    private final FirebaseTrace mFirebaseTrace;
    private final AnnotationInfo mAnnotationInfo;
    private boolean mTraceAdded = false;

    private FirebaseTimerAnnotationProcessor(AdviceAdapter adviceAdapter, AnnotationInfo annotationInfo) {
        this.mFirebaseTrace = new FirebaseTrace(adviceAdapter);
        this.mAnnotationInfo = annotationInfo;
    }

    @Override
    public void onMethodEnter() {
        Object enabled = this.mAnnotationInfo.values.get(TIMER_ANNOTATION_ATTR_ENABLED);
        boolean startTrace = true;
        if (enabled != null && enabled instanceof Boolean) {
            startTrace = (Boolean)enabled;
        }
        try {
            if (startTrace) {
                this.mFirebaseTrace.start(this.mAnnotationInfo.values.get(TIMER_ANNOTATION_ATTR_NAME).toString());
                this.mTraceAdded = true;
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onMethodExit() {
        try {
            if (this.mTraceAdded) {
                this.mFirebaseTrace.stop();
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Factory
    implements AnnotatedMethodInstrumentationFactory {
        @Override
        public AnnotatedMethodAdapter newAnnotatedMethodInstrumentation(InstrumentationContext instrContext, AdviceAdapter mv, AnnotationInfo ai, String methodName, String methodDesc) {
            return new FirebaseTimerAnnotationProcessor(mv, ai);
        }
    }
}

