/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationFactory;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

public class InstrumentationConfigImpl
implements InstrumentationConfig {
    private final ClassLoader classLoader;
    private final List<AnnotatedMethodInstrumentationConfig> annotatedMethodConfigs;
    private final List<NetworkObjectInstrumentationConfig> networkObjectConfigs;
    private final Set<String> missingClasses = new HashSet<String>();

    public InstrumentationConfigImpl(ClassLoader classLoader, List<AnnotatedMethodInstrumentationConfig> annotatedMethodConfigs, List<NetworkObjectInstrumentationConfig> networkObjectConfigs) {
        this.classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
        this.annotatedMethodConfigs = Collections.unmodifiableList(annotatedMethodConfigs);
        this.networkObjectConfigs = Collections.unmodifiableList(networkObjectConfigs);
    }

    @Override
    @Nullable
    public NetworkObjectInstrumentationFactory getNetworkObjectInstrumentationFactory(String className, String methodName, String methodDesc) {
        Class<?> clazz;
        Type classType = Type.getObjectType((String)className);
        if (classType.getSort() != 10) {
            return null;
        }
        try {
            clazz = Class.forName(classType.getClassName(), false, this.classLoader);
        }
        catch (Exception | LinkageError e) {
            return null;
        }
        for (NetworkObjectInstrumentationConfig networkObjectConfig : this.networkObjectConfigs) {
            Type networkClassType = Type.getObjectType((String)networkObjectConfig.getClassName());
            String networkClassName = networkClassType.getClassName();
            if (this.missingClasses.contains(networkClassName)) continue;
            try {
                Class<?> networkClass = Class.forName(networkClassName, false, this.classLoader);
                boolean isInst = networkClass.isAssignableFrom(clazz);
                boolean methodMatch = networkObjectConfig.getMethodName().equals(methodName);
                boolean descMatch = networkObjectConfig.getMethodDesc().equals(methodDesc);
                if (!isInst || !methodMatch || !descMatch) continue;
                return networkObjectConfig.getFactory();
            }
            catch (Exception | LinkageError e) {
                this.missingClasses.add(networkClassName);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<AnnotatedMethodInstrumentationFactory> getAnnotatedMethodInstrumentationFactories(String classDesc) {
        ArrayList<AnnotatedMethodInstrumentationFactory> annotatedMethodFactoryList = null;
        for (AnnotatedMethodInstrumentationConfig annotatedMethodConfig : this.annotatedMethodConfigs) {
            if (!annotatedMethodConfig.getClassDesc().equals(classDesc)) continue;
            if (annotatedMethodFactoryList == null) {
                annotatedMethodFactoryList = new ArrayList<AnnotatedMethodInstrumentationFactory>();
            }
            annotatedMethodFactoryList.add(annotatedMethodConfig.getFactory());
        }
        return annotatedMethodFactoryList;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

