/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation.annotation;

import com.google.firebase.perf.plugin.instrumentation.InstrumentationContext;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodAdapter;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationFactory;
import com.google.firebase.perf.plugin.instrumentation.model.AnnotationInfo;
import com.google.firebase.perf.plugin.sdk.FirebaseTrace;
import org.objectweb.asm.commons.AdviceAdapter;

public class FirebaseTimerAnnotationProcessor
implements AnnotatedMethodAdapter {
    private static final String TIMER_ANNOTATION_ATTR_NAME = "name";
    private static final String TIMER_ANNOTATION_ATTR_ENABLED = "enabled";
    private final FirebaseTrace firebaseTrace;
    private final AnnotationInfo annotationInfo;
    private boolean traceAdded = false;

    private FirebaseTimerAnnotationProcessor(AdviceAdapter adviceAdapter, AnnotationInfo annotationInfo) {
        this.firebaseTrace = new FirebaseTrace(adviceAdapter);
        this.annotationInfo = annotationInfo;
    }

    @Override
    public void onMethodEnter() {
        boolean startTrace;
        Object enabled = this.annotationInfo.values.get(TIMER_ANNOTATION_ATTR_ENABLED);
        boolean bl = startTrace = enabled instanceof Boolean ? (Boolean)enabled : true;
        if (startTrace) {
            this.firebaseTrace.start(this.annotationInfo.values.get(TIMER_ANNOTATION_ATTR_NAME).toString());
            this.traceAdded = true;
        }
    }

    @Override
    public void onMethodExit() {
        if (this.traceAdded) {
            this.firebaseTrace.stop();
        }
    }

    public static class Factory
    implements AnnotatedMethodInstrumentationFactory {
        @Override
        public AnnotatedMethodAdapter newAnnotatedMethodInstrumentation(InstrumentationContext instrContext, AdviceAdapter adviceAdapter, AnnotationInfo annotationInfo, String methodName, String methodDesc) {
            return new FirebaseTimerAnnotationProcessor(adviceAdapter, annotationInfo);
        }
    }
}

