/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation.network;

import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationFactory;

public abstract class NetworkObjectInstrumentationConfig {
    private final NetworkObjectInstrumentationFactory networkObjectFactory;
    private final String className;
    private final String methodName;
    private final String methodDesc;
    private final String id;

    public NetworkObjectInstrumentationConfig(NetworkObjectInstrumentationFactory networkObjectFactory, String className, String methodName, String methodDesc) {
        this.networkObjectFactory = networkObjectFactory;
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.id = NetworkObjectInstrumentationConfig.getId(className, methodName, methodDesc);
    }

    public NetworkObjectInstrumentationFactory getFactory() {
        return this.networkObjectFactory;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetworkObjectInstrumentationConfig)) {
            return false;
        }
        NetworkObjectInstrumentationConfig that = (NetworkObjectInstrumentationConfig)obj;
        return that.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static String getId(String className, String methodName, String methodDesc) {
        return className + methodName + methodDesc;
    }
}

