/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "be" locale.
 */
public class LocalizedNamesImpl_be extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "BY",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "BQ",
        "CP",
        "DG",
        "EA",
        "IC",
        "MF",
        "SX",
        "TA",
        "UM",
        "XK",
        "AE",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "OM",
        "AS",
        "VI",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "CK",
        "PN",
        "AU",
        "AT",
        "AF",
        "BS",
        "BG",
        "BO",
        "BD",
        "BB",
        "BW",
        "BH",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BA",
        "BR",
        "BN",
        "IO",
        "VG",
        "BV",
        "BF",
        "BI",
        "BT",
        "VN",
        "VU",
        "VA",
        "HU",
        "VE",
        "QO",
        "GG",
        "JE",
        "CW",
        "YT",
        "IM",
        "NF",
        "CX",
        "HM",
        "GB",
        "GA",
        "HT",
        "GM",
        "GH",
        "HN",
        "GY",
        "GP",
        "GT",
        "GN",
        "GW",
        "DE",
        "GI",
        "HK",
        "GE",
        "GD",
        "GL",
        "GR",
        "GU",
        "DM",
        "DO",
        "DK",
        "DJ",
        "EG",
        "YE",
        "EU",
        "ZM",
        "EH",
        "ZW",
        "US",
        "JO",
        "IL",
        "ID",
        "IN",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "CV",
        "KZ",
        "KY",
        "CC",
        "CO",
        "KH",
        "CM",
        "KM",
        "CA",
        "QA",
        "KE",
        "CY",
        "KI",
        "CN",
        "CG",
        "CD",
        "CR",
        "CI",
        "CU",
        "KW",
        "KG",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MM",
        "MG",
        "MZ",
        "MO",
        "MK",
        "MW",
        "MY",
        "MD",
        "ML",
        "MV",
        "MT",
        "MC",
        "MN",
        "MS",
        "MA",
        "MQ",
        "MH",
        "MU",
        "MR",
        "MX",
        "FM",
        "NA",
        "NO",
        "NR",
        "NP",
        "NE",
        "NG",
        "AN",
        "NL",
        "NI",
        "NU",
        "NZ",
        "NC",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PT",
        "ZA",
        "GS",
        "KR",
        "SS",
        "KP",
        "MP",
        "PE",
        "PL",
        "PR",
        "RU",
        "RW",
        "RO",
        "RE",
        "SB",
        "SV",
        "SO",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SJ",
        "SH",
        "SC",
        "BL",
        "SN",
        "PM",
        "VC",
        "KN",
        "LC",
        "RS",
        "SG",
        "SY",
        "SK",
        "SI",
        "SD",
        "SR",
        "SL",
        "TJ",
        "TW",
        "TH",
        "TK",
        "TZ",
        "TG",
        "TO",
        "TT",
        "TV",
        "TN",
        "TM",
        "TR",
        "UG",
        "UZ",
        "UA",
        "WF",
        "UY",
        "TL",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "GF",
        "PF",
        "TF",
        "FR",
        "HR",
        "TC",
        "CF",
        "TD",
        "ME",
        "CL",
        "CZ",
        "CH",
        "SE",
        "LK",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "JM",
        "JP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Свет");
    namesMap.put("002", "Афрыка");
    namesMap.put("003", "Паўночная Амэрыка");
    namesMap.put("005", "Паўднёвая Амэрыка");
    namesMap.put("009", "Акіянія");
    namesMap.put("011", "Заходняя Афрыка");
    namesMap.put("013", "Цэнтральная Амэрыка");
    namesMap.put("014", "Усходняя Афрыка");
    namesMap.put("015", "Паўночная Афрыка");
    namesMap.put("017", "Цэнтральная Афрыка");
    namesMap.put("018", "Паўднёвая Афрыка");
    namesMap.put("019", "Паўночная і Паўднёвая Амерыкі");
    namesMap.put("021", "ЗША і Канада");
    namesMap.put("029", "Карыбскія астравы");
    namesMap.put("030", "Усходняя Азія");
    namesMap.put("034", "Паўднёвая Азія");
    namesMap.put("035", "Паўднёва-Усходняя Азія");
    namesMap.put("039", "Паўднёвая Еўропа");
    namesMap.put("053", "Аўстралія і Новая Зэландыя");
    namesMap.put("061", "Палінезія");
    namesMap.put("142", "Азія");
    namesMap.put("143", "Цэнтральная Азія");
    namesMap.put("145", "Заходняя Азія");
    namesMap.put("150", "Еўропа");
    namesMap.put("151", "Усходняя Еўропа");
    namesMap.put("154", "Паўночная Еўропа");
    namesMap.put("155", "Заходняя Еўропа");
    namesMap.put("AD", "Андора");
    namesMap.put("AE", "Аб'яднаныя Арабскія Эміраты");
    namesMap.put("AF", "Афганістан");
    namesMap.put("AG", "Антыгуа і Барбуда");
    namesMap.put("AI", "Ангілья");
    namesMap.put("AL", "Албанія");
    namesMap.put("AM", "Арменія");
    namesMap.put("AN", "Нідэрландскія Антылы");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктыка");
    namesMap.put("AR", "Аргенціна");
    namesMap.put("AS", "Амерыканскае Самоа");
    namesMap.put("AT", "Аўстрыя");
    namesMap.put("AU", "Аўстралія");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландскія астравы");
    namesMap.put("AZ", "Азербайджан");
    namesMap.put("BA", "Боснія і Герцагавіна");
    namesMap.put("BB", "Барбадас");
    namesMap.put("BD", "Бангладэш");
    namesMap.put("BE", "Бельгія");
    namesMap.put("BF", "Буркіна-Фасо");
    namesMap.put("BG", "Балгарыя");
    namesMap.put("BH", "Бахрэйн");
    namesMap.put("BI", "Бурундзі");
    namesMap.put("BJ", "Бенін");
    namesMap.put("BL", "Сен-Бартэльмі");
    namesMap.put("BM", "Бермудскія астравы");
    namesMap.put("BN", "Бруней");
    namesMap.put("BO", "Балівія");
    namesMap.put("BR", "Бразілія");
    namesMap.put("BS", "Багамы");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Бувэ востраў");
    namesMap.put("BW", "Батсвана");
    namesMap.put("BY", "Беларусь");
    namesMap.put("BZ", "Беліз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Какосавыя астравы");
    namesMap.put("CD", "Конга, Дэмакратычная Рэспубліка");
    namesMap.put("CF", "Цэнтральна-Афрыканская Рэспубліка");
    namesMap.put("CG", "Конга");
    namesMap.put("CH", "Швейцарыя");
    namesMap.put("CI", "Кот-д'Івуар");
    namesMap.put("CK", "Астравы Кука");
    namesMap.put("CL", "Чылі");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Кітай");
    namesMap.put("CO", "Калумбія");
    namesMap.put("CR", "Коста-Рыка");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Каба-Вердэ");
    namesMap.put("CW", "Востраў Кюрасаа");
    namesMap.put("CX", "Востраў Ражства");
    namesMap.put("CY", "Кіпр");
    namesMap.put("CZ", "Чэхія");
    namesMap.put("DE", "Германія");
    namesMap.put("DJ", "Джыбуці");
    namesMap.put("DK", "Данія");
    namesMap.put("DM", "Дамініка");
    namesMap.put("DO", "Дамініканская Рэспубліка");
    namesMap.put("DZ", "Алжыр");
    namesMap.put("EC", "Эквадор");
    namesMap.put("EE", "Эстонія");
    namesMap.put("EG", "Егіпет");
    namesMap.put("EH", "Заходняя Сахара");
    namesMap.put("ER", "Эрытрэя");
    namesMap.put("ES", "Іспанія");
    namesMap.put("ET", "Эфіопія");
    namesMap.put("EU", "Еўрапейскі Звяз");
    namesMap.put("FI", "Фінляндыя");
    namesMap.put("FJ", "Фіджы");
    namesMap.put("FK", "Фолклэндскія астравы");
    namesMap.put("FM", "Мікранезія");
    namesMap.put("FO", "Фарэрскія астравы");
    namesMap.put("FR", "Францыя");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Вялікабрытанія");
    namesMap.put("GD", "Грэнада");
    namesMap.put("GE", "Грузія");
    namesMap.put("GF", "Французская Гвіяна");
    namesMap.put("GG", "Востраў Гернсі");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гібралтар");
    namesMap.put("GL", "Грэнландыя");
    namesMap.put("GM", "Гамбія");
    namesMap.put("GN", "Гвінея");
    namesMap.put("GP", "Гвадэлупа");
    namesMap.put("GQ", "Экватарыяльная Гвінея");
    namesMap.put("GR", "Грэцыя");
    namesMap.put("GS", "Паўднёвая Джорджыя і Паўднёвыя Сандвічавы астравы");
    namesMap.put("GT", "Гватэмала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвінея-Бісау");
    namesMap.put("GY", "Гаяна");
    namesMap.put("HK", "Гон-Конг, Кітай (САР)");
    namesMap.put("HM", "Востраў Херд і Астравы Макдоналд");
    namesMap.put("HN", "Гандурас");
    namesMap.put("HR", "Харватыя");
    namesMap.put("HT", "Гаіці");
    namesMap.put("HU", "Венгрыя");
    namesMap.put("ID", "Інданезія");
    namesMap.put("IE", "Ірландыя");
    namesMap.put("IL", "Ізраіль");
    namesMap.put("IM", "Востраў Мэн");
    namesMap.put("IN", "Індыя");
    namesMap.put("IO", "Брытанская тэрыторыя ў Індыйскім акіяне");
    namesMap.put("IQ", "Ірак");
    namesMap.put("IR", "Іран");
    namesMap.put("IS", "Ісландыя");
    namesMap.put("IT", "Італія");
    namesMap.put("JE", "Востраў Джэрсі");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Іарданія");
    namesMap.put("JP", "Японія");
    namesMap.put("KE", "Кенія");
    namesMap.put("KG", "Кыргызстан");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кірыбаці");
    namesMap.put("KM", "Каморскія Астравы");
    namesMap.put("KN", "Сент-Кітс і Невіс");
    namesMap.put("KP", "Паўночная Карэя");
    namesMap.put("KR", "Паўднёвая Карэя");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайманавы астравы");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ліван");
    namesMap.put("LC", "Сент-Люсія");
    namesMap.put("LI", "Ліхтэнштэйн");
    namesMap.put("LK", "Шры-Ланка");
    namesMap.put("LR", "Ліберыя");
    namesMap.put("LS", "Лесота");
    namesMap.put("LT", "Літва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвія");
    namesMap.put("LY", "Лівія");
    namesMap.put("MA", "Марока");
    namesMap.put("MC", "Манака");
    namesMap.put("MD", "Малдова");
    namesMap.put("ME", "Чарнагорыя");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалавы Астравы");
    namesMap.put("MK", "Македонія, БЮР");
    namesMap.put("ML", "Малі");
    namesMap.put("MM", "М'янма");
    namesMap.put("MN", "Манголія");
    namesMap.put("MO", "Макао, Кітай (САР)");
    namesMap.put("MP", "Паўночныя Марыянскія астравы");
    namesMap.put("MQ", "Марцініка");
    namesMap.put("MR", "Маўрытанія");
    namesMap.put("MS", "Мантсерат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маўрыкій");
    namesMap.put("MV", "Мальдывы");
    namesMap.put("MW", "Малаві");
    namesMap.put("MX", "Мексіка");
    namesMap.put("MY", "Малайзія");
    namesMap.put("MZ", "Мазамбік");
    namesMap.put("NA", "Намібія");
    namesMap.put("NC", "Новая Каледонія");
    namesMap.put("NE", "Нігер");
    namesMap.put("NF", "Востраў Норфалк");
    namesMap.put("NG", "Нігерыя");
    namesMap.put("NI", "Нікарагуа");
    namesMap.put("NL", "Нідэрланды");
    namesMap.put("NO", "Нарвегія");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ніуэ");
    namesMap.put("NZ", "Новая Зеландыя");
    namesMap.put("OM", "Аман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Французская Палінезія");
    namesMap.put("PG", "Папуа — Новая Гвінея");
    namesMap.put("PH", "Філіпіны");
    namesMap.put("PK", "Пакістан");
    namesMap.put("PL", "Польшча");
    namesMap.put("PM", "Сен-П'ер і Мікелон");
    namesMap.put("PN", "Астравы Піткэрн");
    namesMap.put("PR", "Пуэрта-Рыка");
    namesMap.put("PS", "Палестынскія тэрыторыі");
    namesMap.put("PT", "Партугалія");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Вонкавая Акіянія");
    namesMap.put("RE", "Рэюньён");
    namesMap.put("RO", "Румынія");
    namesMap.put("RS", "Сербія");
    namesMap.put("RU", "Расія");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудаўская Аравія");
    namesMap.put("SB", "Саламонавы Астравы");
    namesMap.put("SC", "Сейшэльскія Астравы");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швецыя");
    namesMap.put("SG", "Сінгапур");
    namesMap.put("SH", "Святой Алены, Востраў");
    namesMap.put("SI", "Славенія");
    namesMap.put("SJ", "Свальбард (Паўночна-Усходняя Зямля) і Ян-Маен");
    namesMap.put("SK", "Славакія");
    namesMap.put("SL", "Сьера-Леонэ");
    namesMap.put("SM", "Сан-Марына");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Самалі");
    namesMap.put("SR", "Сурынам");
    namesMap.put("SS", "Паўднёвы Судан");
    namesMap.put("ST", "Сан-Тамэ і Прынсіпі");
    namesMap.put("SV", "Сальвадор");
    namesMap.put("SY", "Сірыя");
    namesMap.put("SZ", "Свазіленд");
    namesMap.put("TC", "Цёркс і Кайкас");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Французскія Паўднёвыя тэрыторыі");
    namesMap.put("TG", "Тога");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Таджыкістан");
    namesMap.put("TK", "Такелау");
    namesMap.put("TL", "Усходні Тымор");
    namesMap.put("TM", "Туркменістан");
    namesMap.put("TN", "Туніс");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Турцыя");
    namesMap.put("TT", "Трынідад і Табага");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайвань");
    namesMap.put("TZ", "Танзанія");
    namesMap.put("UA", "Украіна");
    namesMap.put("UG", "Уганда");
    namesMap.put("US", "Злучаныя Штаты Амерыкі");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Узбекістан");
    namesMap.put("VA", "Ватыкан");
    namesMap.put("VC", "Сент-Вінсент і Грэнадзіны");
    namesMap.put("VE", "Венесуэла");
    namesMap.put("VG", "Брытанскія Віргінскія астравы");
    namesMap.put("VI", "Амерыканскія Віргінскія астравы");
    namesMap.put("VN", "В'етнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоліс і Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("YE", "Емен");
    namesMap.put("YT", "Востраў Маёта");
    namesMap.put("ZA", "Паўднёва-Афрыканская Рэспубліка");
    namesMap.put("ZM", "Замбія");
    namesMap.put("ZW", "Зімбабвэ");
    namesMap.put("ZZ", "Невядомы рэгіён");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Свет",
        "002": "Афрыка",
        "003": "Паўночная Амэрыка",
        "005": "Паўднёвая Амэрыка",
        "009": "Акіянія",
        "011": "Заходняя Афрыка",
        "013": "Цэнтральная Амэрыка",
        "014": "Усходняя Афрыка",
        "015": "Паўночная Афрыка",
        "017": "Цэнтральная Афрыка",
        "018": "Паўднёвая Афрыка",
        "019": "Паўночная і Паўднёвая Амерыкі",
        "021": "ЗША і Канада",
        "029": "Карыбскія астравы",
        "030": "Усходняя Азія",
        "034": "Паўднёвая Азія",
        "035": "Паўднёва-Усходняя Азія",
        "039": "Паўднёвая Еўропа",
        "053": "Аўстралія і Новая Зэландыя",
        "061": "Палінезія",
        "142": "Азія",
        "143": "Цэнтральная Азія",
        "145": "Заходняя Азія",
        "150": "Еўропа",
        "151": "Усходняя Еўропа",
        "154": "Паўночная Еўропа",
        "155": "Заходняя Еўропа",
        "AD": "Андора",
        "AE": "Аб'яднаныя Арабскія Эміраты",
        "AF": "Афганістан",
        "AG": "Антыгуа і Барбуда",
        "AI": "Ангілья",
        "AL": "Албанія",
        "AM": "Арменія",
        "AN": "Нідэрландскія Антылы",
        "AO": "Ангола",
        "AQ": "Антарктыка",
        "AR": "Аргенціна",
        "AS": "Амерыканскае Самоа",
        "AT": "Аўстрыя",
        "AU": "Аўстралія",
        "AW": "Аруба",
        "AX": "Аландскія астравы",
        "AZ": "Азербайджан",
        "BA": "Боснія і Герцагавіна",
        "BB": "Барбадас",
        "BD": "Бангладэш",
        "BE": "Бельгія",
        "BF": "Буркіна-Фасо",
        "BG": "Балгарыя",
        "BH": "Бахрэйн",
        "BI": "Бурундзі",
        "BJ": "Бенін",
        "BL": "Сен-Бартэльмі",
        "BM": "Бермудскія астравы",
        "BN": "Бруней",
        "BO": "Балівія",
        "BR": "Бразілія",
        "BS": "Багамы",
        "BT": "Бутан",
        "BV": "Бувэ востраў",
        "BW": "Батсвана",
        "BY": "Беларусь",
        "BZ": "Беліз",
        "CA": "Канада",
        "CC": "Какосавыя астравы",
        "CD": "Конга, Дэмакратычная Рэспубліка",
        "CF": "Цэнтральна-Афрыканская Рэспубліка",
        "CG": "Конга",
        "CH": "Швейцарыя",
        "CI": "Кот-д'Івуар",
        "CK": "Астравы Кука",
        "CL": "Чылі",
        "CM": "Камерун",
        "CN": "Кітай",
        "CO": "Калумбія",
        "CR": "Коста-Рыка",
        "CU": "Куба",
        "CV": "Каба-Вердэ",
        "CW": "Востраў Кюрасаа",
        "CX": "Востраў Ражства",
        "CY": "Кіпр",
        "CZ": "Чэхія",
        "DE": "Германія",
        "DJ": "Джыбуці",
        "DK": "Данія",
        "DM": "Дамініка",
        "DO": "Дамініканская Рэспубліка",
        "DZ": "Алжыр",
        "EC": "Эквадор",
        "EE": "Эстонія",
        "EG": "Егіпет",
        "EH": "Заходняя Сахара",
        "ER": "Эрытрэя",
        "ES": "Іспанія",
        "ET": "Эфіопія",
        "EU": "Еўрапейскі Звяз",
        "FI": "Фінляндыя",
        "FJ": "Фіджы",
        "FK": "Фолклэндскія астравы",
        "FM": "Мікранезія",
        "FO": "Фарэрскія астравы",
        "FR": "Францыя",
        "GA": "Габон",
        "GB": "Вялікабрытанія",
        "GD": "Грэнада",
        "GE": "Грузія",
        "GF": "Французская Гвіяна",
        "GG": "Востраў Гернсі",
        "GH": "Гана",
        "GI": "Гібралтар",
        "GL": "Грэнландыя",
        "GM": "Гамбія",
        "GN": "Гвінея",
        "GP": "Гвадэлупа",
        "GQ": "Экватарыяльная Гвінея",
        "GR": "Грэцыя",
        "GS": "Паўднёвая Джорджыя і Паўднёвыя Сандвічавы астравы",
        "GT": "Гватэмала",
        "GU": "Гуам",
        "GW": "Гвінея-Бісау",
        "GY": "Гаяна",
        "HK": "Гон-Конг, Кітай (САР)",
        "HM": "Востраў Херд і Астравы Макдоналд",
        "HN": "Гандурас",
        "HR": "Харватыя",
        "HT": "Гаіці",
        "HU": "Венгрыя",
        "ID": "Інданезія",
        "IE": "Ірландыя",
        "IL": "Ізраіль",
        "IM": "Востраў Мэн",
        "IN": "Індыя",
        "IO": "Брытанская тэрыторыя ў Індыйскім акіяне",
        "IQ": "Ірак",
        "IR": "Іран",
        "IS": "Ісландыя",
        "IT": "Італія",
        "JE": "Востраў Джэрсі",
        "JM": "Ямайка",
        "JO": "Іарданія",
        "JP": "Японія",
        "KE": "Кенія",
        "KG": "Кыргызстан",
        "KH": "Камбоджа",
        "KI": "Кірыбаці",
        "KM": "Каморскія Астравы",
        "KN": "Сент-Кітс і Невіс",
        "KP": "Паўночная Карэя",
        "KR": "Паўднёвая Карэя",
        "KW": "Кувейт",
        "KY": "Кайманавы астравы",
        "KZ": "Казахстан",
        "LA": "Лаос",
        "LB": "Ліван",
        "LC": "Сент-Люсія",
        "LI": "Ліхтэнштэйн",
        "LK": "Шры-Ланка",
        "LR": "Ліберыя",
        "LS": "Лесота",
        "LT": "Літва",
        "LU": "Люксембург",
        "LV": "Латвія",
        "LY": "Лівія",
        "MA": "Марока",
        "MC": "Манака",
        "MD": "Малдова",
        "ME": "Чарнагорыя",
        "MG": "Мадагаскар",
        "MH": "Маршалавы Астравы",
        "MK": "Македонія, БЮР",
        "ML": "Малі",
        "MM": "М'янма",
        "MN": "Манголія",
        "MO": "Макао, Кітай (САР)",
        "MP": "Паўночныя Марыянскія астравы",
        "MQ": "Марцініка",
        "MR": "Маўрытанія",
        "MS": "Мантсерат",
        "MT": "Мальта",
        "MU": "Маўрыкій",
        "MV": "Мальдывы",
        "MW": "Малаві",
        "MX": "Мексіка",
        "MY": "Малайзія",
        "MZ": "Мазамбік",
        "NA": "Намібія",
        "NC": "Новая Каледонія",
        "NE": "Нігер",
        "NF": "Востраў Норфалк",
        "NG": "Нігерыя",
        "NI": "Нікарагуа",
        "NL": "Нідэрланды",
        "NO": "Нарвегія",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ніуэ",
        "NZ": "Новая Зеландыя",
        "OM": "Аман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Французская Палінезія",
        "PG": "Папуа — Новая Гвінея",
        "PH": "Філіпіны",
        "PK": "Пакістан",
        "PL": "Польшча",
        "PM": "Сен-П'ер і Мікелон",
        "PN": "Астравы Піткэрн",
        "PR": "Пуэрта-Рыка",
        "PS": "Палестынскія тэрыторыі",
        "PT": "Партугалія",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Вонкавая Акіянія",
        "RE": "Рэюньён",
        "RO": "Румынія",
        "RS": "Сербія",
        "RU": "Расія",
        "RW": "Руанда",
        "SA": "Саудаўская Аравія",
        "SB": "Саламонавы Астравы",
        "SC": "Сейшэльскія Астравы",
        "SD": "Судан",
        "SE": "Швецыя",
        "SG": "Сінгапур",
        "SH": "Святой Алены, Востраў",
        "SI": "Славенія",
        "SJ": "Свальбард (Паўночна-Усходняя Зямля) і Ян-Маен",
        "SK": "Славакія",
        "SL": "Сьера-Леонэ",
        "SM": "Сан-Марына",
        "SN": "Сенегал",
        "SO": "Самалі",
        "SR": "Сурынам",
        "SS": "Паўднёвы Судан",
        "ST": "Сан-Тамэ і Прынсіпі",
        "SV": "Сальвадор",
        "SY": "Сірыя",
        "SZ": "Свазіленд",
        "TC": "Цёркс і Кайкас",
        "TD": "Чад",
        "TF": "Французскія Паўднёвыя тэрыторыі",
        "TG": "Тога",
        "TH": "Тайланд",
        "TJ": "Таджыкістан",
        "TK": "Такелау",
        "TL": "Усходні Тымор",
        "TM": "Туркменістан",
        "TN": "Туніс",
        "TO": "Тонга",
        "TR": "Турцыя",
        "TT": "Трынідад і Табага",
        "TV": "Тувалу",
        "TW": "Тайвань",
        "TZ": "Танзанія",
        "UA": "Украіна",
        "UG": "Уганда",
        "US": "Злучаныя Штаты Амерыкі",
        "UY": "Уругвай",
        "UZ": "Узбекістан",
        "VA": "Ватыкан",
        "VC": "Сент-Вінсент і Грэнадзіны",
        "VE": "Венесуэла",
        "VG": "Брытанскія Віргінскія астравы",
        "VI": "Амерыканскія Віргінскія астравы",
        "VN": "В'етнам",
        "VU": "Вануату",
        "WF": "Уоліс і Футуна",
        "WS": "Самоа",
        "YE": "Емен",
        "YT": "Востраў Маёта",
        "ZA": "Паўднёва-Афрыканская Рэспубліка",
        "ZM": "Замбія",
        "ZW": "Зімбабвэ",
        "ZZ": "Невядомы рэгіён"
    };
  }-*/;
}
