/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.common;

public class Timestamp {
    private static final long MAX_SECONDS = 315576000000L;
    private static final int MAX_NANOS = 999999999;
    private static final long NUM_MILLIS_PER_SECOND = 1000L;
    private static final int NUM_NANOS_PER_MILLI = 1000000;
    private final long seconds;
    private final int nanos;

    public static Timestamp create(long l, int n) {
        if (l < -315576000000L || l > 315576000000L) {
            return new Timestamp(0L, 0);
        }
        if (n < 0 || n > 999999999) {
            return new Timestamp(0L, 0);
        }
        return new Timestamp(l, n);
    }

    public static Timestamp fromMillis(long l) {
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        if (n < 0) {
            return new Timestamp(l2 - 1L, 999999999 + n + 1);
        }
        return new Timestamp(l2, n);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)object;
        return this.seconds == timestamp.seconds && this.nanos == timestamp.nanos;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + (int)(this.seconds ^ this.seconds >>> 32);
        n = 31 * n + this.nanos;
        return n;
    }

    public String toString() {
        return "Timestamp<" + this.seconds + "," + this.nanos + ">";
    }

    private Timestamp(long l, int n) {
        this.seconds = l;
        this.nanos = n;
    }
}

