/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;

class GatherCharacterEncodingBias
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final NameGenerator nameGenerator;
    private final AbstractCompiler compiler;
    private final boolean renameGlobaVars;

    public GatherCharacterEncodingBias(AbstractCompiler compiler, NameGenerator ng, boolean renameGlobalVars) {
        this.compiler = compiler;
        this.nameGenerator = ng;
        this.renameGlobaVars = renameGlobalVars;
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, this).traverse(root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 43: 
            case 44: {
                return;
            }
            case 153: {
                return;
            }
            case 38: {
                this.visitName(t, n);
                return;
            }
            case 105: {
                if (!NodeUtil.isGetOrSetKey(n.getParent())) {
                    this.nameGenerator.favors("function");
                }
                return;
            }
            case 108: {
                this.nameGenerator.favors("if");
                if (n.getFirstChild().getNext().getNext() != null) {
                    this.nameGenerator.favors("else");
                }
                return;
            }
            case 115: {
                this.nameGenerator.favors("for");
                return;
            }
            case 113: {
                this.nameGenerator.favors("while");
                return;
            }
            case 118: {
                this.nameGenerator.favors("var");
                return;
            }
            case 40: {
                this.nameGenerator.favors(n.getString());
                return;
            }
            case 154: {
                this.nameGenerator.favors(n.getString());
                return;
            }
            case 77: {
                this.nameGenerator.favors("try");
                if (NodeUtil.hasFinally(n)) {
                    this.nameGenerator.favors("finally");
                }
                return;
            }
            case 120: {
                this.nameGenerator.favors("catch");
                return;
            }
            case 110: {
                this.nameGenerator.favors("switch");
                return;
            }
            case 111: {
                this.nameGenerator.favors("case");
                return;
            }
            case 112: {
                this.nameGenerator.favors("default");
                return;
            }
            case 30: {
                this.nameGenerator.favors("new");
                return;
            }
            case 4: {
                this.nameGenerator.favors("return");
                return;
            }
            case 114: {
                this.nameGenerator.favors("do");
                this.nameGenerator.favors("while");
                return;
            }
            case 122: {
                this.nameGenerator.favors("void");
                return;
            }
            case 119: {
                this.nameGenerator.favors("with");
                return;
            }
            case 31: {
                this.nameGenerator.favors("delete");
                return;
            }
            case 32: {
                this.nameGenerator.favors("typeof");
                return;
            }
            case 49: {
                this.nameGenerator.favors("throw");
                return;
            }
            case 51: {
                this.nameGenerator.favors("in");
                return;
            }
            case 52: {
                this.nameGenerator.favors("instanceof");
                return;
            }
            case 116: {
                this.nameGenerator.favors("break");
                return;
            }
            case 117: {
                this.nameGenerator.favors("continue");
                return;
            }
            case 42: {
                this.nameGenerator.favors("this");
                return;
            }
            case 41: {
                this.nameGenerator.favors("null");
                return;
            }
            case 152: {
                this.nameGenerator.favors("debugger");
                return;
            }
            case 147: {
                this.nameGenerator.favors("get");
                return;
            }
            case 148: {
                this.nameGenerator.favors("set");
                return;
            }
            case 39: {
                return;
            }
        }
    }

    private void visitName(NodeTraversal t, Node n) {
        Preconditions.checkArgument((n.getType() == 38 ? 1 : 0) != 0);
        if (this.renameGlobaVars) {
            return;
        }
        String name = n.getString();
        Scope.Var var = t.getScope().getVar(name);
        if (var == null || var.scope.isGlobal()) {
            this.nameGenerator.favors(name);
        }
    }
}

