/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.lib;

import gradlegitproperties.org.eclipse.jgit.lib.AnyObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.Constants;
import gradlegitproperties.org.eclipse.jgit.lib.GpgSignature;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectBuilder;
import gradlegitproperties.org.eclipse.jgit.lib.ObjectId;
import gradlegitproperties.org.eclipse.jgit.lib.PersonIdent;
import gradlegitproperties.org.eclipse.jgit.util.References;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class CommitBuilder
extends ObjectBuilder {
    private static final ObjectId[] EMPTY_OBJECTID_LIST = new ObjectId[0];
    private static final byte[] htree = Constants.encodeASCII("tree");
    private static final byte[] hparent = Constants.encodeASCII("parent");
    private static final byte[] hauthor = Constants.encodeASCII("author");
    private static final byte[] hcommitter = Constants.encodeASCII("committer");
    private static final byte[] hgpgsig = Constants.encodeASCII("gpgsig");
    private ObjectId treeId;
    private ObjectId[] parentIds = EMPTY_OBJECTID_LIST;
    private PersonIdent committer;

    public ObjectId getTreeId() {
        return this.treeId;
    }

    public void setTreeId(AnyObjectId id) {
        this.treeId = id.copy();
    }

    @Override
    public PersonIdent getAuthor() {
        return super.getAuthor();
    }

    @Override
    public void setAuthor(PersonIdent newAuthor) {
        super.setAuthor(newAuthor);
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public void setCommitter(PersonIdent newCommitter) {
        this.committer = newCommitter;
    }

    public ObjectId[] getParentIds() {
        return this.parentIds;
    }

    public void setParentId(AnyObjectId newParent) {
        this.parentIds = new ObjectId[]{newParent.copy()};
    }

    public void setParentIds(AnyObjectId parent1, AnyObjectId parent2) {
        this.parentIds = new ObjectId[]{parent1.copy(), parent2.copy()};
    }

    public void setParentIds(ObjectId ... newParents) {
        this.parentIds = new ObjectId[newParents.length];
        int i = 0;
        while (i < newParents.length) {
            this.parentIds[i] = newParents[i].copy();
            ++i;
        }
    }

    public void setParentIds(List<? extends AnyObjectId> newParents) {
        this.parentIds = new ObjectId[newParents.size()];
        int i = 0;
        while (i < newParents.size()) {
            this.parentIds[i] = newParents.get(i).copy();
            ++i;
        }
    }

    public void addParentId(AnyObjectId additionalParent) {
        if (this.parentIds.length == 0) {
            this.setParentId(additionalParent);
        } else {
            ObjectId[] newParents = new ObjectId[this.parentIds.length + 1];
            System.arraycopy(this.parentIds, 0, newParents, 0, this.parentIds.length);
            newParents[this.parentIds.length] = additionalParent.copy();
            this.parentIds = newParents;
        }
    }

    @Deprecated
    public void setEncoding(String encodingName) {
        this.setEncoding(Charset.forName(encodingName));
    }

    @Override
    public byte[] build() throws UnsupportedEncodingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, this.getEncoding());
        try {
            os.write(htree);
            os.write(32);
            this.getTreeId().copyTo(os);
            os.write(10);
            ObjectId[] objectIdArray = this.getParentIds();
            int n = objectIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectId p = objectIdArray[n2];
                os.write(hparent);
                os.write(32);
                p.copyTo(os);
                os.write(10);
                ++n2;
            }
            os.write(hauthor);
            os.write(32);
            w.write(this.getAuthor().toExternalString());
            w.flush();
            os.write(10);
            os.write(hcommitter);
            os.write(32);
            w.write(this.getCommitter().toExternalString());
            w.flush();
            os.write(10);
            GpgSignature signature = this.getGpgSignature();
            if (signature != null) {
                os.write(hgpgsig);
                os.write(32);
                CommitBuilder.writeMultiLineHeader(signature.toExternalString(), os, true);
                os.write(10);
            }
            CommitBuilder.writeEncoding(this.getEncoding(), os);
            os.write(10);
            if (this.getMessage() != null) {
                w.write(this.getMessage());
                w.flush();
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return os.toByteArray();
    }

    public byte[] toByteArray() throws UnsupportedEncodingException {
        return this.build();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Commit");
        r.append("={\n");
        r.append("tree ");
        r.append(this.treeId != null ? this.treeId.name() : "NOT_SET");
        r.append("\n");
        ObjectId[] objectIdArray = this.parentIds;
        int n = this.parentIds.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectId p = objectIdArray[n2];
            r.append("parent ");
            r.append(p.name());
            r.append("\n");
            ++n2;
        }
        r.append("author ");
        r.append(this.getAuthor() != null ? this.getAuthor().toString() : "NOT_SET");
        r.append("\n");
        r.append("committer ");
        r.append(this.committer != null ? this.committer.toString() : "NOT_SET");
        r.append("\n");
        r.append("gpgSignature ");
        GpgSignature signature = this.getGpgSignature();
        r.append(signature != null ? signature.toString() : "NOT_SET");
        r.append("\n");
        Charset encoding = this.getEncoding();
        if (!References.isSameObject(encoding, StandardCharsets.UTF_8)) {
            r.append("encoding ");
            r.append(encoding.name());
            r.append("\n");
        }
        r.append("\n");
        r.append(this.getMessage() != null ? this.getMessage() : "");
        r.append("}");
        return r.toString();
    }
}

