/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.transport;

import gradlegitproperties.org.eclipse.jgit.lib.ObjectId;
import gradlegitproperties.org.eclipse.jgit.transport.URIish;
import java.io.IOException;
import java.io.Writer;

class FetchHeadRecord {
    ObjectId newValue;
    boolean notForMerge;
    String sourceName;
    URIish sourceURI;

    FetchHeadRecord() {
    }

    void write(Writer pw) throws IOException {
        String name;
        String type;
        if (this.sourceName.startsWith("refs/heads/")) {
            type = "branch";
            name = this.sourceName.substring("refs/heads/".length());
        } else if (this.sourceName.startsWith("refs/tags/")) {
            type = "tag";
            name = this.sourceName.substring("refs/tags/".length());
        } else if (this.sourceName.startsWith("refs/remotes/")) {
            type = "remote branch";
            name = this.sourceName.substring("refs/remotes/".length());
        } else {
            type = "";
            name = this.sourceName;
        }
        pw.write(this.newValue.name());
        pw.write(9);
        if (this.notForMerge) {
            pw.write("not-for-merge");
        }
        pw.write(9);
        pw.write(type);
        pw.write(" '");
        pw.write(name);
        pw.write("' of ");
        pw.write(this.sourceURI.toString());
        pw.write("\n");
    }
}

