/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.treewalk.filter;

import gradlegitproperties.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import gradlegitproperties.org.eclipse.jgit.errors.MissingObjectException;
import gradlegitproperties.org.eclipse.jgit.internal.JGitText;
import gradlegitproperties.org.eclipse.jgit.lib.Constants;
import gradlegitproperties.org.eclipse.jgit.treewalk.TreeWalk;
import gradlegitproperties.org.eclipse.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;

public class PathSuffixFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathSuffixFilter create(String path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathSuffixFilter(path);
    }

    private PathSuffixFilter(String s) {
        this.pathStr = s;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (walker.isSubtree()) {
            return true;
        }
        return walker.isPathSuffix(this.pathRaw, this.pathRaw.length);
    }

    @Override
    public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (walker.isSubtree()) {
            return -1;
        }
        return super.matchFilter(walker);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }
}

