/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.Utils;
import com.gradle.enterprise.gradleplugin.GradleEnterpriseBuildCache;
import com.gradle.enterprise.gradleplugin.GradleEnterpriseExtension;
import com.gradle.scan.plugin.BuildScanExtension;
import java.time.Duration;
import java.util.Optional;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.caching.http.HttpBuildCache;
import org.gradle.caching.local.DirectoryBuildCache;

final class Overrides {
    static final String GRADLE_ENTERPRISE_URL = "gradle.enterprise.url";
    static final String GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER = "gradle.enterprise.allowUntrustedServer";
    static final String LOCAL_CACHE_DIRECTORY = "gradle.cache.local.directory";
    static final String LOCAL_CACHE_REMOVE_UNUSED_ENTRIES_AFTER_DAYS = "gradle.cache.local.removeUnusedEntriesAfterDays";
    static final String LOCAL_CACHE_ENABLED = "gradle.cache.local.enabled";
    static final String LOCAL_CACHE_PUSH = "gradle.cache.local.push";
    static final String REMOTE_CACHE_URL = "gradle.cache.remote.url";
    static final String REMOTE_CACHE_SERVER = "gradle.cache.remote.server";
    static final String REMOTE_CACHE_PATH = "gradle.cache.remote.path";
    static final String REMOTE_CACHE_ALLOW_UNTRUSTED_SERVER = "gradle.cache.remote.allowUntrustedServer";
    static final String REMOTE_CACHE_ALLOW_INSECURE_PROTOCOL = "gradle.cache.remote.allowInsecureProtocol";
    static final String REMOTE_CACHE_ENABLED = "gradle.cache.remote.enabled";
    static final String REMOTE_CACHE_PUSH = "gradle.cache.remote.push";
    private final ProviderFactory providers;

    Overrides(ProviderFactory providers) {
        this.providers = providers;
    }

    void configureGradleEnterprise(GradleEnterpriseExtension gradleEnterprise) {
        Overrides.sysPropertyOrEnvVariable(GRADLE_ENTERPRISE_URL, this.providers).ifPresent(arg_0 -> ((GradleEnterpriseExtension)gradleEnterprise).setServer(arg_0));
        Overrides.booleanSysPropertyOrEnvVariable(GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER, this.providers).ifPresent(arg_0 -> ((GradleEnterpriseExtension)gradleEnterprise).setAllowUntrustedServer(arg_0));
    }

    void configureGradleEnterpriseOnGradle4(BuildScanExtension buildScan) {
        Overrides.sysPropertyOrEnvVariable(GRADLE_ENTERPRISE_URL, this.providers).ifPresent(arg_0 -> ((BuildScanExtension)buildScan).setServer(arg_0));
        Overrides.booleanSysPropertyOrEnvVariable(GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER, this.providers).ifPresent(arg_0 -> ((BuildScanExtension)buildScan).setAllowUntrustedServer(arg_0));
    }

    void configureBuildCache(BuildCacheConfiguration buildCache) {
        buildCache.local(local -> {
            Overrides.sysPropertyOrEnvVariable(LOCAL_CACHE_DIRECTORY, this.providers).ifPresent(arg_0 -> ((DirectoryBuildCache)local).setDirectory(arg_0));
            Overrides.durationSysPropertyOrEnvVariable(LOCAL_CACHE_REMOVE_UNUSED_ENTRIES_AFTER_DAYS, this.providers).ifPresent(v -> local.setRemoveUnusedEntriesAfterDays((int)v.toDays()));
            Overrides.booleanSysPropertyOrEnvVariable(LOCAL_CACHE_ENABLED, this.providers).ifPresent(arg_0 -> ((DirectoryBuildCache)local).setEnabled(arg_0));
            Overrides.booleanSysPropertyOrEnvVariable(LOCAL_CACHE_PUSH, this.providers).ifPresent(arg_0 -> ((DirectoryBuildCache)local).setPush(arg_0));
        });
        if (buildCache.getRemote() instanceof HttpBuildCache) {
            buildCache.remote(HttpBuildCache.class, remote -> {
                Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_URL, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setUrl(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_UNTRUSTED_SERVER, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setAllowUntrustedServer(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_INSECURE_PROTOCOL, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setAllowInsecureProtocol(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ENABLED, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setEnabled(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_PUSH, this.providers).ifPresent(arg_0 -> ((HttpBuildCache)remote).setPush(arg_0));
            });
        } else if (buildCache.getRemote() instanceof GradleEnterpriseBuildCache) {
            buildCache.remote(GradleEnterpriseBuildCache.class, remote -> {
                Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_SERVER, this.providers).ifPresent(arg_0 -> ((GradleEnterpriseBuildCache)remote).setServer(arg_0));
                Overrides.sysPropertyOrEnvVariable(REMOTE_CACHE_PATH, this.providers).ifPresent(arg_0 -> ((GradleEnterpriseBuildCache)remote).setPath(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_UNTRUSTED_SERVER, this.providers).ifPresent(arg_0 -> ((GradleEnterpriseBuildCache)remote).setAllowUntrustedServer(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ALLOW_INSECURE_PROTOCOL, this.providers).ifPresent(arg_0 -> ((GradleEnterpriseBuildCache)remote).setAllowInsecureProtocol(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_ENABLED, this.providers).ifPresent(arg_0 -> ((GradleEnterpriseBuildCache)remote).setEnabled(arg_0));
                Overrides.booleanSysPropertyOrEnvVariable(REMOTE_CACHE_PUSH, this.providers).ifPresent(arg_0 -> ((GradleEnterpriseBuildCache)remote).setPush(arg_0));
            });
        }
    }

    static Optional<String> sysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.sysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    static Optional<Boolean> booleanSysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.booleanSysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    static Optional<Duration> durationSysPropertyOrEnvVariable(String sysPropertyName, ProviderFactory providers) {
        return Utils.durationSysPropertyOrEnvVariable(sysPropertyName, Overrides.toEnvVarName(sysPropertyName), providers);
    }

    private static String toEnvVarName(String sysPropertyName) {
        return sysPropertyName.toUpperCase().replace('.', '_');
    }
}

