/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.CustomBuildScanEnhancements;
import com.gradle.CustomDevelocityConfig;
import com.gradle.Overrides;
import com.gradle.Utils;
import com.gradle.develocity.agent.gradle.adapters.BuildScanAdapter;
import com.gradle.develocity.agent.gradle.adapters.DevelocityAdapter;
import com.gradle.develocity.agent.gradle.adapters.develocity.DevelocityConfigurationAdapter;
import com.gradle.develocity.agent.gradle.adapters.enterprise.BuildScanExtension_1_X_Adapter;
import com.gradle.develocity.agent.gradle.adapters.enterprise.GradleEnterpriseExtensionAdapter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.caching.configuration.BuildCacheConfiguration;

public class CommonCustomUserDataGradlePlugin
implements Plugin<Object> {
    private final ProviderFactory providers;

    @Inject
    public CommonCustomUserDataGradlePlugin(ProviderFactory providers) {
        this.providers = providers;
    }

    public void apply(Object target) {
        if (target instanceof Settings) {
            if (!Utils.isGradle6OrNewer()) {
                throw new GradleException("For Gradle versions prior to 6.0, common-custom-user-data-gradle-plugin must be applied to the Root project");
            }
            this.applySettingsPlugin((Settings)target);
        } else if (target instanceof Project) {
            if (Utils.isGradle6OrNewer()) {
                throw new GradleException("For Gradle versions 6.0 and newer, common-custom-user-data-gradle-plugin must be applied to Settings");
            }
            if (Utils.isGradle5OrNewer()) {
                this.applyProjectPluginGradle5((Project)target);
            } else if (Utils.isGradle4OrNewer()) {
                this.applyProjectPluginGradle4((Project)target);
            } else {
                throw new GradleException("For Gradle versions prior to 4.0, common-custom-user-data-gradle-plugin is not supported");
            }
        }
    }

    public static void apply(Object develocityConfiguration, ProviderFactory providers, Settings settings) {
        CommonCustomUserDataGradlePlugin.applySettingsPlugin(new DevelocityConfigurationAdapter(develocityConfiguration), providers, settings);
    }

    private static void applySettingsPlugin(DevelocityAdapter develocity, ProviderFactory providers, Settings settings) {
        CustomDevelocityConfig customDevelocityConfig = new CustomDevelocityConfig();
        customDevelocityConfig.configureDevelocity(develocity);
        BuildScanAdapter buildScan = develocity.getBuildScan();
        customDevelocityConfig.configureBuildScanPublishing(buildScan);
        CustomBuildScanEnhancements buildScanEnhancements = new CustomBuildScanEnhancements(develocity, providers, settings.getGradle());
        buildScanEnhancements.apply();
        BuildCacheConfiguration buildCache = settings.getBuildCache();
        customDevelocityConfig.configureBuildCache(buildCache);
        Action settingsAction = __ -> {
            Overrides overrides = new Overrides(providers);
            overrides.configureDevelocity(develocity);
            overrides.configureBuildCache(buildCache, develocity.getBuildCache());
        };
        if (CommonCustomUserDataGradlePlugin.settingsHaveBeenEvaluated()) {
            settingsAction.execute((Object)settings);
        } else {
            settings.getGradle().settingsEvaluated(settingsAction);
        }
    }

    private void applySettingsPlugin(Settings settings) {
        AtomicBoolean somePluginAlreadyConfigured = new AtomicBoolean(false);
        settings.getPluginManager().withPlugin("com.gradle.develocity", __ -> {
            if (somePluginAlreadyConfigured.compareAndSet(false, true)) {
                CommonCustomUserDataGradlePlugin.applySettingsPlugin(CommonCustomUserDataGradlePlugin.createDevelocityAdapter(settings), this.providers, settings);
            }
        });
        settings.getPluginManager().withPlugin("com.gradle.enterprise", __ -> {
            if (somePluginAlreadyConfigured.compareAndSet(false, true)) {
                CommonCustomUserDataGradlePlugin.applySettingsPlugin(CommonCustomUserDataGradlePlugin.createDevelocityAdapter(settings), this.providers, settings);
            }
        });
    }

    private void applyProjectPluginGradle5(Project project) {
        CommonCustomUserDataGradlePlugin.ensureRootProject(project);
        AtomicBoolean somePluginAlreadyConfigured = new AtomicBoolean(false);
        project.getPluginManager().withPlugin("com.gradle.develocity", __ -> {
            if (somePluginAlreadyConfigured.compareAndSet(false, true)) {
                this.applyProjectPlugin(project, CommonCustomUserDataGradlePlugin.createDevelocityAdapter(project));
            }
        });
        project.getPluginManager().withPlugin("com.gradle.build-scan", __ -> {
            if (somePluginAlreadyConfigured.compareAndSet(false, true)) {
                this.applyProjectPlugin(project, CommonCustomUserDataGradlePlugin.createDevelocityAdapter(project));
            }
        });
    }

    private static <T extends ExtensionAware> DevelocityAdapter createDevelocityAdapter(T target) {
        ExtensionContainer extensions = target.getExtensions();
        Object develocityExtension = extensions.findByName("develocity");
        if (develocityExtension != null) {
            return new DevelocityConfigurationAdapter(develocityExtension);
        }
        return new GradleEnterpriseExtensionAdapter(extensions.getByName("gradleEnterprise"));
    }

    private void applyProjectPluginGradle4(Project project) {
        CommonCustomUserDataGradlePlugin.ensureRootProject(project);
        project.getPluginManager().withPlugin("com.gradle.build-scan", __ -> this.applyProjectPlugin(project, new BuildScanExtension_1_X_Adapter(project.getExtensions().getByName("buildScan"))));
    }

    private void applyProjectPlugin(Project project, DevelocityAdapter develocity) {
        CustomDevelocityConfig customDevelocityConfig = new CustomDevelocityConfig();
        customDevelocityConfig.configureDevelocity(develocity);
        BuildScanAdapter buildScan = develocity.getBuildScan();
        customDevelocityConfig.configureBuildScanPublishing(buildScan);
        CustomBuildScanEnhancements buildScanEnhancements = new CustomBuildScanEnhancements(develocity, this.providers, project.getGradle());
        buildScanEnhancements.apply();
        project.afterEvaluate(___ -> {
            Overrides overrides = new Overrides(this.providers);
            overrides.configureDevelocity(develocity);
        });
    }

    private static void ensureRootProject(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new GradleException("common-custom-user-data-gradle-plugin may only be applied to the Root project");
        }
    }

    private static boolean settingsHaveBeenEvaluated() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getMethodName).anyMatch(s -> s.contains("settingsEvaluated"));
    }
}

