/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle.adapters.internal;

import java.util.Arrays;
import java.util.stream.Stream;

public class AdapterTypeUtils {
    private static final String DEVELOCITY_CONFIGURATION = "com.gradle.develocity.agent.gradle.DevelocityConfiguration";
    private static final String GRADLE_ENTERPRISE_EXTENSION = "com.gradle.enterprise.gradleplugin.GradleEnterpriseExtension";
    private static final String BUILD_SCAN_EXTENSION = "com.gradle.scan.plugin.BuildScanExtension";

    private AdapterTypeUtils() {
    }

    public static void checkIsDevelocityConfiguration(Object gradleEnterpriseOrDevelocity) {
        AdapterTypeUtils.throwIfNotImplementsInterface(gradleEnterpriseOrDevelocity, DEVELOCITY_CONFIGURATION, "Develocity configuration");
    }

    public static void checkIsGradleEnterpriseExtension(Object gradleEnterpriseOrDevelocity) {
        AdapterTypeUtils.throwIfNotImplementsInterface(gradleEnterpriseOrDevelocity, GRADLE_ENTERPRISE_EXTENSION, "Gradle Enterprise extension");
    }

    public static void checkIsBuildScanExtension(Object gradleEnterpriseOrDevelocity) {
        AdapterTypeUtils.throwIfNotImplementsInterface(gradleEnterpriseOrDevelocity, BUILD_SCAN_EXTENSION, "Build Scan extension");
    }

    private static void throwIfNotImplementsInterface(Object gradleEnterpriseOrDevelocity, String interfaceName, String expectedTypeDisplayName) {
        if (!AdapterTypeUtils.implementsInterface(gradleEnterpriseOrDevelocity, interfaceName)) {
            throw new IllegalArgumentException("The supplied object of type '" + gradleEnterpriseOrDevelocity.getClass().getName() + "' is not a " + expectedTypeDisplayName + " object");
        }
    }

    private static boolean implementsInterface(Object object, String interfaceName) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            boolean implementsInterface = Stream.concat(Arrays.stream(interfaces), Arrays.stream(interfaces).flatMap(it -> Arrays.stream(it.getInterfaces()))).anyMatch(it -> interfaceName.equals(it.getName()));
            if (!implementsInterface) continue;
            return true;
        }
        return false;
    }
}

