/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle.adapters.develocity;

import com.gradle.develocity.agent.gradle.adapters.BuildCacheConfigurationAdapter;
import com.gradle.develocity.agent.gradle.adapters.internal.ReflectionProperty;
import com.gradle.develocity.agent.gradle.adapters.internal.ReflectionUtils;
import java.net.URI;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.caching.http.HttpBuildCache;
import org.gradle.caching.local.DirectoryBuildCache;
import org.jetbrains.annotations.Nullable;

public class GradleBuildCacheConfigurationAdapter
implements BuildCacheConfigurationAdapter {
    private final BuildCacheConfiguration buildCache;

    public GradleBuildCacheConfigurationAdapter(BuildCacheConfiguration buildCache) {
        this.buildCache = buildCache;
    }

    @Override
    public BuildCacheConfigurationAdapter.LocalBuildCacheAdapter getLocal() {
        return new LocalBuildCache(this.buildCache.getLocal());
    }

    @Override
    @Nullable
    public BuildCacheConfigurationAdapter.RemoteBuildCacheAdapter getRemote() {
        BuildCache remoteConfig = this.buildCache.getRemote();
        if (remoteConfig == null) {
            return null;
        }
        return new ReflectingRemoteBuildCache(remoteConfig);
    }

    private static class ReflectingRemoteBuildCache
    implements BuildCacheConfigurationAdapter.RemoteBuildCacheAdapter {
        private final BuildCache remoteBuildCache;
        private final ReflectionProperty<URI> url;
        private final ReflectionProperty<String> server;
        private final ReflectionProperty<String> path;
        private final ReflectionProperty<Boolean> allowUntrustedServer;
        private final ReflectionProperty<Boolean> allowInsecureProtocol;
        private final ReflectionProperty<Boolean> useExpectContinue;

        private ReflectingRemoteBuildCache(BuildCache remoteBuildCache) {
            this.remoteBuildCache = remoteBuildCache;
            this.url = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "getUrl", "setUrl");
            this.server = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "getServer", "setServer");
            this.path = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "getPath", "setPath");
            if (remoteBuildCache instanceof HttpBuildCache) {
                this.allowUntrustedServer = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "isAllowUntrustedServer", "setAllowUntrustedServer", false);
                this.allowInsecureProtocol = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "isAllowInsecureProtocol", "setAllowInsecureProtocol", false);
                this.useExpectContinue = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "isUseExpectContinue", "setUseExpectContinue", false);
            } else {
                this.allowUntrustedServer = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "getAllowUntrustedServer", "setAllowUntrustedServer", false);
                this.allowInsecureProtocol = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "getAllowInsecureProtocol", "setAllowInsecureProtocol", false);
                this.useExpectContinue = ReflectionProperty.forGetterAndSetter(remoteBuildCache, "getUseExpectContinue", "setUseExpectContinue", false);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.remoteBuildCache.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.remoteBuildCache.setEnabled(enabled);
        }

        @Override
        public boolean isPush() {
            return this.remoteBuildCache.isPush();
        }

        @Override
        public void setPush(boolean push) {
            this.remoteBuildCache.setPush(push);
        }

        @Override
        @Nullable
        public String getUrl() {
            URI value = this.url.get();
            return value == null ? null : value.toASCIIString();
        }

        @Override
        public void setUrl(@Nullable String value) {
            URI uriValue = value == null ? null : URI.create(value);
            this.url.set(uriValue);
        }

        @Override
        @Nullable
        public String getServer() {
            return this.server.get();
        }

        @Override
        public void setServer(@Nullable String value) {
            this.server.set(value);
        }

        @Override
        @Nullable
        public String getPath() {
            return this.path.get();
        }

        @Override
        public void setPath(@Nullable String value) {
            this.path.set(value);
        }

        @Override
        public boolean getAllowUntrustedServer() {
            return this.allowUntrustedServer.get();
        }

        @Override
        public void setAllowUntrustedServer(boolean value) {
            this.allowUntrustedServer.set(value);
        }

        @Override
        public boolean getAllowInsecureProtocol() {
            return this.allowInsecureProtocol.get();
        }

        @Override
        public void setAllowInsecureProtocol(boolean value) {
            this.allowInsecureProtocol.set(value);
        }

        @Override
        public boolean getUseExpectContinue() {
            return this.useExpectContinue.get();
        }

        @Override
        public void setUseExpectContinue(boolean value) {
            this.useExpectContinue.set(value);
        }

        @Override
        @Nullable
        public Object getUsernameAndPassword() {
            return ReflectionUtils.invokeMethod(this.remoteBuildCache, "getUsernameAndPassword", new Object[0]);
        }

        @Override
        public void usernameAndPassword(String username, String password) {
            ReflectionUtils.invokeMethod(this.remoteBuildCache, "usernameAndPassword", username, password);
        }
    }

    private static class LocalBuildCache
    implements BuildCacheConfigurationAdapter.LocalBuildCacheAdapter {
        private final DirectoryBuildCache localBuildCache;

        private LocalBuildCache(DirectoryBuildCache localBuildCache) {
            this.localBuildCache = localBuildCache;
        }

        @Override
        public boolean isEnabled() {
            return this.localBuildCache.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.localBuildCache.setEnabled(enabled);
        }

        @Override
        public boolean isPush() {
            return this.localBuildCache.isPush();
        }

        @Override
        public void setPush(boolean push) {
            this.localBuildCache.setPush(push);
        }

        @Override
        public String getDirectory() {
            return String.valueOf(this.localBuildCache.getDirectory());
        }

        @Override
        public void setDirectory(String directory) {
            this.localBuildCache.setDirectory((Object)directory);
        }

        @Override
        public int getRemoveUnusedEntriesAfterDays() {
            return this.localBuildCache.getRemoveUnusedEntriesAfterDays();
        }

        @Override
        public void setRemoveUnusedEntriesAfterDays(int days) {
            this.localBuildCache.setRemoveUnusedEntriesAfterDays(days);
        }
    }
}

