/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.embedded.EmbeddedChannel;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.Brotli;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.BrotliDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.SnappyFrameDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.ZlibCodecFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.ZlibWrapper;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpContentDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaderValues;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;

    public HttpContentDecompressor() {
        this(false);
    }

    public HttpContentDecompressor(boolean bl2) {
        this.strict = bl2;
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String string) throws Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(string) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(string)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(string) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(string)) {
            ZlibWrapper zlibWrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(zlibWrapper));
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(string)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new BrotliDecoder());
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(string)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new SnappyFrameDecoder());
        }
        return null;
    }
}

