/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslEngineMap;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSession;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSessionCache;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.scan.plugin.internal.dep.io.netty.util.AsciiString;
import java.util.HashMap;
import java.util.Map;

final class OpenSslClientSessionCache
extends OpenSslSessionCache {
    private final Map<HostPort, OpenSslSessionCache.NativeSslSession> sessions = new HashMap<HostPort, OpenSslSessionCache.NativeSslSession>();

    OpenSslClientSessionCache(OpenSslEngineMap openSslEngineMap) {
        super(openSslEngineMap);
    }

    @Override
    protected void sessionRemoved(OpenSslSessionCache.NativeSslSession nativeSslSession) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(nativeSslSession.getPeerHost(), nativeSslSession.getPeerPort());
        if (hostPort == null) {
            return;
        }
        this.sessions.remove(hostPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean setSession(long l2, OpenSslSession openSslSession, String string, int n2) {
        boolean bl2;
        OpenSslSessionCache.NativeSslSession nativeSslSession;
        HostPort hostPort = OpenSslClientSessionCache.keyFor(string, n2);
        if (hostPort == null) {
            return false;
        }
        boolean bl3 = false;
        OpenSslClientSessionCache openSslClientSessionCache = this;
        synchronized (openSslClientSessionCache) {
            nativeSslSession = this.sessions.get(hostPort);
            if (nativeSslSession == null) {
                return false;
            }
            if (!nativeSslSession.isValid()) {
                this.removeSessionWithId(nativeSslSession.sessionId());
                return false;
            }
            bl2 = SSL.setSession((long)l2, (long)nativeSslSession.session());
            if (bl2) {
                bl3 = nativeSslSession.shouldBeSingleUse();
            }
        }
        if (bl2) {
            if (bl3) {
                nativeSslSession.invalidate();
                openSslSession.invalidate();
            }
            nativeSslSession.setLastAccessedTime(System.currentTimeMillis());
            openSslSession.setSessionDetails(nativeSslSession.getCreationTime(), nativeSslSession.getLastAccessedTime(), nativeSslSession.sessionId(), nativeSslSession.keyValueStorage);
        }
        return bl2;
    }

    private static HostPort keyFor(String string, int n2) {
        if (string == null && n2 < 1) {
            return null;
        }
        return new HostPort(string, n2);
    }

    @Override
    synchronized void clear() {
        super.clear();
        this.sessions.clear();
    }

    private static final class HostPort {
        private final int hash;
        private final String host;
        private final int port;

        HostPort(String string, int n2) {
            this.host = string;
            this.port = n2;
            this.hash = 31 * AsciiString.hashCode(string) + n2;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HostPort)) {
                return false;
            }
            HostPort hostPort = (HostPort)object;
            return this.port == hostPort.port && this.host.equalsIgnoreCase(hostPort.host);
        }

        public String toString() {
            return "HostPort{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

