/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.channel.group;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.Channel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ServerChannel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.group.ChannelMatcher;

public final class ChannelMatchers {
    private static final ChannelMatcher ALL_MATCHER = new ChannelMatcher(){

        @Override
        public boolean matches(Channel channel) {
            return true;
        }
    };
    private static final ChannelMatcher SERVER_CHANNEL_MATCHER = ChannelMatchers.isInstanceOf(ServerChannel.class);
    private static final ChannelMatcher NON_SERVER_CHANNEL_MATCHER = ChannelMatchers.isNotInstanceOf(ServerChannel.class);

    public static ChannelMatcher all() {
        return ALL_MATCHER;
    }

    public static ChannelMatcher isInstanceOf(Class<? extends Channel> clazz) {
        return new ClassMatcher(clazz);
    }

    public static ChannelMatcher isNotInstanceOf(Class<? extends Channel> clazz) {
        return ChannelMatchers.invert(ChannelMatchers.isInstanceOf(clazz));
    }

    public static ChannelMatcher invert(ChannelMatcher channelMatcher) {
        return new InvertMatcher(channelMatcher);
    }

    private static final class ClassMatcher
    implements ChannelMatcher {
        private final Class<? extends Channel> clazz;

        ClassMatcher(Class<? extends Channel> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean matches(Channel channel) {
            return this.clazz.isInstance(channel);
        }
    }

    private static final class InvertMatcher
    implements ChannelMatcher {
        private final ChannelMatcher matcher;

        InvertMatcher(ChannelMatcher channelMatcher) {
            this.matcher = channelMatcher;
        }

        @Override
        public boolean matches(Channel channel) {
            return !this.matcher.matches(channel);
        }
    }
}

