/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.impl.conn;

import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpHost;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.apache.http.ProtocolException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.config.RequestConfig;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.protocol.HttpClientContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.SchemePortResolver;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.UnsupportedSchemeException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.routing.HttpRoute;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.routing.HttpRoutePlanner;
import com.gradle.scan.plugin.internal.dep.org.apache.http.impl.conn.DefaultSchemePortResolver;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.net.InetAddress;

public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        HttpHost httpHost2;
        Args.notNull(httpRequest, "Request");
        if (httpHost == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        InetAddress inetAddress = requestConfig.getLocalAddress();
        HttpHost httpHost3 = requestConfig.getProxy();
        if (httpHost3 == null) {
            httpHost3 = this.determineProxy(httpHost, httpRequest, httpContext);
        }
        if (httpHost.getPort() <= 0) {
            try {
                httpHost2 = new HttpHost(httpHost.getHostName(), this.schemePortResolver.resolve(httpHost), httpHost.getSchemeName());
            }
            catch (UnsupportedSchemeException unsupportedSchemeException) {
                throw new HttpException(unsupportedSchemeException.getMessage());
            }
        } else {
            httpHost2 = httpHost;
        }
        boolean bl2 = httpHost2.getSchemeName().equalsIgnoreCase("https");
        return httpHost3 == null ? new HttpRoute(httpHost2, inetAddress, bl2) : new HttpRoute(httpHost2, inetAddress, httpHost3, bl2);
    }

    protected HttpHost determineProxy(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        return null;
    }
}

