package com.gradle.enterprise.gradleplugin.testselection;

import com.gradle.obfuscation.Keep;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Internal;

/**
 * Task extension for configuring Predictive Test Selection.
 * <p>
 * This extension is added with name {@value #NAME} to all {@link org.gradle.api.tasks.testing.Test Test} tasks.
 */
@Keep
public interface PredictiveTestSelectionExtension {

    /**
     * The name of the extension added to each test task.
     */
    String NAME = "predictiveSelection";

    /**
     * Whether Predictive Test Selection is enabled.
     * <p>
     * This setting defaults to {@code false}, which results in the task executing tests
     * with the built-in non-distributed test infrastructure.
     *
     * @return whether Predictive Test Selection is enabled
     */
    @Internal
    Property<Boolean> getEnabled();

    /**
     * The set of criteria for specifying which tests must always run.
     */
    @Internal
    MustRunCriteria getMustRun();

    /**
     * The set of criteria for specifying which tests must always run.
     */
    void mustRun(Action<? super MustRunCriteria> action);

    /**
     * A set of criteria for specifying which tests must always run.
     * <p>
     * By default, no tests are considered as must run tests.
     */
    @Keep
    interface MustRunCriteria {

        /**
         * The patterns used to include tests based on their class name.
         * <p>
         * The pattern string matches against qualified class names.
         * It may contain '*' characters, which match zero or more of any character.
         * <p>
         * A class name only has to match one pattern to be included.
         */
        SetProperty<String> getIncludeClasses();

        /**
         * The patterns used to include tests based on their class level annotations.
         * <p>
         * The pattern string matches against the qualified class names of a test class's annotations.
         * It may contain '*' characters, which match zero or more of any character.
         * <p>
         * A class need only have one annotation matching any of the patterns to be included.
         * <p>
         * Annotations present on super classes that are {@code @Inherited} are considered when inspecting subclasses.
         */
        SetProperty<String> getIncludeAnnotationClasses();
    }
}
