package com.gradle.publish;

import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;

import java.util.Collection;

public class ConfigValidator extends AbstractConfigValidator {

    public ConfigValidator(boolean skipNamespaceCheck) {
        super(skipNamespaceCheck);
    }

    @Override
    public void validateConfig(GradlePluginDevelopmentExtension extension) {
        if (extension.getPlugins().isEmpty()) {
            throw new IllegalArgumentException("No plugins defined. Please declare at least one plugin in a 'gradlePlugin.plugins' block");
        }

        validateURLs(Util.getWebsite(extension), Util.getVcsUrl(extension));

        validatePluginIdUniqueness(extension);

        for(PluginDeclaration plugin : extension.getPlugins()) {
            validatePluginConfig(plugin);
        }
    }

    @Override
    public void validatePluginConfig(PluginDeclaration plugin) {
        String pluginName = plugin.getName();
        validatePluginId(pluginName, plugin.getId());
        validateDisplayName(pluginName, plugin.getDisplayName());
        validateDescription(pluginName, plugin.getDescription());
        validateImplementationClass(pluginName, plugin.getImplementationClass());

        validateTags(plugin);
    }

    @Override
    public void validateTags(PluginDeclaration plugin) {
        Collection<String> tags = Util.getTags(plugin);
        validateTags(plugin.getName(), tags);
    }
}
