package com.gradle.publish;

import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;

import java.util.*;

public class LegacyConfigValidator extends AbstractConfigValidator {

    private final PluginBundleExtension bundleConfig;

    public LegacyConfigValidator(PluginBundleExtension bundleConfig, boolean skipNamespaceCheck) {
        super(skipNamespaceCheck);
        this.bundleConfig = bundleConfig;
    }

    @Override
    public void validateConfig(GradlePluginDevelopmentExtension pluginConfig) {
        if (pluginConfig.getPlugins().isEmpty()) {
            throw new IllegalArgumentException("No plugins defined. Please declare at least one plugin in a 'gradlePlugin.plugins' block");
        }
        validateURLs(bundleConfig.getWebsite(), bundleConfig.getVcsUrl());

        validatePluginIdUniqueness(pluginConfig);
        validatePluginTagKeys(pluginConfig);
        for(PluginDeclaration plugin : pluginConfig.getPlugins()) {
            validatePluginConfig(plugin);
        }
    }

    @Override
    public void validatePluginConfig(PluginDeclaration plugin) {
        String pluginName = plugin.getName();
        validatePluginId(pluginName, plugin.getId());
        validateDisplayName(pluginName, plugin.getDisplayName());
        validateDescription(pluginName, plugin.getDescription() == null ? bundleConfig.getDescription() : plugin.getDescription());
        validateImplementationClass(pluginName, plugin.getImplementationClass());

        validateTags(plugin);
    }

    @Override
    public void validateTags(PluginDeclaration plugin) {
        String pluginName = plugin.getName();
        Collection<String> tags = Util.getTags(bundleConfig, pluginName);
        validateTags(pluginName, tags);
    }

    private void validatePluginTagKeys(GradlePluginDevelopmentExtension extension) {
        Set<String> plugins = new HashSet<>(bundleConfig.getPluginTags().keySet());
        plugins.removeAll(extension.getPlugins().getNames());
        if (!plugins.isEmpty()) {
            List<String> sortedPlugins = new ArrayList<>(plugins);
            sortedPlugins.sort(String::compareTo);
            throw new IllegalArgumentException("Tags set for undefined plugin(s): " + String.join(", ", sortedPlugins));
        }
    }
}
