package com.gradle.publish;

import org.apache.tools.ant.util.LayoutPreservingProperties;
import org.gradle.api.Project;

import java.io.*;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class PropertiesStore {

    static LayoutPreservingProperties fromFile(File file) throws IOException {
        LayoutPreservingProperties properties = new LayoutPreservingProperties();
        properties.setRemoveComments(true);
        if (file.exists()) {
            InputStream in = null;
            try {
                in = new FileInputStream(file);
                properties.load(in);

            } finally {
                if (in != null) in.close();
            }
        }
        return properties;
    }

    static void append(File propertiesFile, Map<String, String> props, String message) throws IOException {
        FileOutputStream out = null;
        try {
            LayoutPreservingProperties properties = fromFile(propertiesFile);
            out = new FileOutputStream(propertiesFile);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
            properties.store(out, message);
        } finally {
            if (null != out) {
                out.close();
            }
        }
    }

    public static Properties gradleProperties(Project project) {
        Properties properties = new Properties();
        if (null != project.getProperties()) {
            /**
             * The underlying Properties impl is a hash table which will explode with property values which are null and hence we
             * do not use the putAll() method. Some of the values of properties coming back from gradle are null.
             */
            for (Map.Entry<String, ?> entry : project.getProperties().entrySet()) {
                if (null != entry.getValue()) {
                    properties.setProperty(entry.getKey(), entry.getValue().toString());
                }
            }
        }
        return properties;
    }

    public static Properties all(Project project) {
        return PropertiesStore.join(PropertiesStore.gradleProperties(project), System.getProperties());
    }

    public static Properties join(Properties... props) {
        Properties result = new Properties();
        for (Properties properties : props) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String) e.nextElement();
                result.setProperty(key, properties.getProperty(key));
            }
        }
        return result;
    }
}

