/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.alias;

import graphql.Assert;
import graphql.Internal;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Map;

@Internal
public class AliasedScalar
extends GraphQLScalarType {
    private AliasedScalar(String name, String description, Coercing coercing) {
        super(name, description, coercing);
    }

    private static AliasedScalar aliasedScalarImpl(String name, String description, final GraphQLScalarType aliasedScalar) {
        Assert.assertNotNull((Object)aliasedScalar);
        return new AliasedScalar(name, description, (Coercing)new Coercing<Object, Object>(){

            public Object serialize(Object input) throws CoercingSerializeException {
                return aliasedScalar.getCoercing().serialize(input);
            }

            public Object parseValue(Object input) throws CoercingParseValueException {
                return aliasedScalar.getCoercing().parseValue(input);
            }

            public Object parseLiteral(Object input) throws CoercingParseLiteralException {
                return aliasedScalar.getCoercing().parseLiteral(input);
            }

            public Object parseLiteral(Object input, Map<String, Object> variables) throws CoercingParseLiteralException {
                return aliasedScalar.getCoercing().parseLiteral(input, variables);
            }
        });
    }

    public static class Builder {
        private String name;
        private String description;
        private GraphQLScalarType aliasedScalar;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder aliasedScalar(GraphQLScalarType aliasedScalar) {
            this.aliasedScalar = aliasedScalar;
            return this;
        }

        public AliasedScalar build() {
            Assert.assertNotNull((Object)this.name);
            return AliasedScalar.aliasedScalarImpl(this.name, this.description, this.aliasedScalar);
        }
    }
}

