/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.GraphQLError;
import graphql.Scalars;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.validation.constraints.AbstractDirectiveConstraint;
import graphql.validation.rules.ValidationEnvironment;
import java.util.Collections;
import java.util.List;

abstract class AbstractAssertConstraint
extends AbstractDirectiveConstraint {
    public AbstractAssertConstraint(String name) {
        super(name);
    }

    @Override
    public boolean appliesToType(GraphQLInputType inputType) {
        return this.isOneOfTheseTypes(inputType, Scalars.GraphQLBoolean);
    }

    @Override
    protected List<GraphQLError> runConstraint(ValidationEnvironment validationEnvironment) {
        Object validatedValue = validationEnvironment.getValidatedValue();
        if (validatedValue == null) {
            return Collections.emptyList();
        }
        GraphQLDirective directive = validationEnvironment.getContextObject(GraphQLDirective.class, new Object[0]);
        boolean isTrue = this.asBoolean(validatedValue);
        if (!this.isOK(isTrue)) {
            return this.mkError(validationEnvironment, directive, this.mkMessageParams(validatedValue, validationEnvironment, new Object[0]));
        }
        return Collections.emptyList();
    }

    protected abstract boolean isOK(boolean var1);
}

