/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

public class MVSecondaryIndex
extends BaseIndex {
    final MVTable mvTable;
    private final int keyColumns;
    private final String mapName;
    private TransactionStore.TransactionMap<Value, Value> dataMap;

    public MVSecondaryIndex(Database database, MVTable mVTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.mvTable = mVTable;
        this.initBaseIndex(mVTable, n, string, indexColumnArray, indexType);
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(indexColumnArray);
        }
        this.keyColumns = indexColumnArray.length + 1;
        int[] nArray = new int[this.keyColumns];
        for (int i = 0; i < indexColumnArray.length; ++i) {
            nArray[i] = indexColumnArray[i].sortType;
        }
        nArray[this.keyColumns - 1] = 0;
        this.mapName = "index." + this.getId();
        ValueDataType valueDataType = new ValueDataType(database.getCompareMode(), database, nArray);
        ValueDataType valueDataType2 = new ValueDataType(null, null, null);
        this.dataMap = this.mvTable.getTransaction(null).openMap(this.mapName, valueDataType, valueDataType2);
        if (valueDataType != this.dataMap.getKeyType()) {
            throw DbException.throwInternalError("Incompatible key type");
        }
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        Object object;
        Object object2;
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        ValueArray valueArray = this.getKey(row);
        ValueArray valueArray2 = null;
        if (this.indexType.isUnique()) {
            valueArray2 = this.getKey(row);
            valueArray2.getList()[this.keyColumns - 1] = ValueLong.get(Long.MIN_VALUE);
            object2 = (ValueArray)transactionMap.getLatestCeilingKey(valueArray2);
            if (object2 != null && this.compareRows(row, (SearchRow)(object = this.getRow(((ValueArray)object2).getList()))) == 0 && !this.containsNullAndAllowMultipleNull((SearchRow)object)) {
                throw this.getDuplicateKeyException(((Value)object2).toString());
            }
        }
        try {
            transactionMap.put(valueArray, ValueNull.INSTANCE);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90131, this.table.getName());
        }
        if (this.indexType.isUnique()) {
            SearchRow searchRow;
            object2 = transactionMap.keyIterator(valueArray2, true);
            while (object2.hasNext() && this.compareRows(row, searchRow = this.getRow(((ValueArray)(object = (ValueArray)object2.next())).getList())) == 0) {
                if (this.containsNullAndAllowMultipleNull(searchRow) || transactionMap.isSameTransaction((Value)object)) continue;
                if (transactionMap.get((Value)object) != null) {
                    throw this.getDuplicateKeyException(((Value)object).toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    @Override
    public void remove(Session session, Row row) {
        ValueArray valueArray = this.getKey(row);
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.remove(valueArray);
            if (value == null) {
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90131, this.table.getName());
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        ValueArray valueArray = this.getKey(searchRow);
        if (valueArray != null) {
            valueArray.getList()[this.keyColumns - 1] = ValueLong.get(Long.MIN_VALUE);
        }
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return new MVStoreCursor(session, transactionMap.keyIterator(valueArray), searchRow2);
    }

    private ValueArray getKey(SearchRow searchRow) {
        if (searchRow == null) {
            return null;
        }
        Value[] valueArray = new Value[this.keyColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int n = column.getColumnId();
            Value value = searchRow.getValue(n);
            if (value == null) continue;
            valueArray[i] = value.convertTo(column.getType());
        }
        valueArray[this.keyColumns - 1] = ValueLong.get(searchRow.getKey());
        return ValueArray.get(valueArray);
    }

    SearchRow getRow(Value[] valueArray) {
        Row row = this.mvTable.getTemplateRow();
        row.setKey(valueArray[valueArray.length - 1].getLong());
        Column[] columnArray = this.getColumns();
        for (int i = 0; i < valueArray.length - 1; ++i) {
            Column column = columnArray[i];
            int n = column.getColumnId();
            Value value = valueArray[i];
            row.setValue(n, value);
        }
        return row;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter tableFilter, SortOrder sortOrder) {
        try {
            return 10L * this.getCostRangeIndex(nArray, this.dataMap.sizeAsLongMax(), tableFilter, sortOrder);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007);
        }
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            TransactionStore.Transaction transaction = this.mvTable.getTransaction(session);
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        Value value;
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        Value value2 = value = bl ? transactionMap.firstKey() : transactionMap.lastKey();
        while (true) {
            if (value == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
            if (((ValueArray)value).getList()[0] != ValueNull.INSTANCE) break;
            value = bl ? transactionMap.higherKey(value) : transactionMap.lowerKey(value);
        }
        ArrayList arrayList = New.arrayList();
        arrayList.add(value);
        MVStoreCursor mVStoreCursor = new MVStoreCursor(session, arrayList.iterator(), null);
        mVStoreCursor.next();
        return mVStoreCursor;
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
    }

    TransactionStore.TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction transaction = this.mvTable.getTransaction(session);
        return this.dataMap.getInstance(transaction, Long.MAX_VALUE);
    }

    class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Value> it;
        private final SearchRow last;
        private Value current;
        private SearchRow searchRow;
        private Row row;

        public MVStoreCursor(Session session, Iterator<Value> iterator, SearchRow searchRow) {
            this.session = session;
            this.it = iterator;
            this.last = searchRow;
        }

        @Override
        public Row get() {
            SearchRow searchRow;
            if (this.row == null && (searchRow = this.getSearchRow()) != null) {
                this.row = MVSecondaryIndex.this.mvTable.getRow(this.session, searchRow.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = MVSecondaryIndex.this.getRow(((ValueArray)this.current).getList());
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.next();
            this.searchRow = null;
            if (this.current != null && this.last != null && MVSecondaryIndex.this.compareRows(this.getSearchRow(), this.last) > 0) {
                this.searchRow = null;
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

