/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.journal.MapEventJournal;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import javax.annotation.Nonnull;

public class EventJournalWriterMutationObserver
implements MutationObserver {
    private final int partitionId;
    private final MapEventJournal eventJournal;
    private final EventJournalConfig eventJournalConfig;
    private final ObjectNamespace objectNamespace;

    public EventJournalWriterMutationObserver(MapEventJournal eventJournal, MapContainer mapContainer, int partitionId) {
        this.eventJournal = eventJournal;
        this.partitionId = partitionId;
        this.eventJournalConfig = mapContainer.getEventJournalConfig();
        this.objectNamespace = mapContainer.getObjectNamespace();
    }

    public void onPutRecord(@Nonnull Data key, Record record, Object oldValue, boolean backup) {
        this.eventJournal.writeAddEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, record.getValue());
    }

    public void onUpdateRecord(@Nonnull Data key, @Nonnull Record record, Object oldValue, Object newValue, boolean backup) {
        this.eventJournal.writeUpdateEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, oldValue, newValue);
    }

    public void onRemoveRecord(Data key, Record record) {
        this.eventJournal.writeRemoveEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, record.getValue());
    }

    public void onEvictRecord(Data key, Record record) {
        this.eventJournal.writeEvictEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, record.getValue());
    }

    public void onLoadRecord(@Nonnull Data key, @Nonnull Record record, boolean backup) {
        this.eventJournal.writeLoadEvent(this.eventJournalConfig, this.objectNamespace, this.partitionId, key, record.getValue());
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
        if (!internal) {
            this.eventJournal.destroy(this.objectNamespace, this.partitionId);
        }
    }

    public void onReplicationPutRecord(@Nonnull Data key, @Nonnull Record record, boolean populateIndex) {
    }

    @Override
    public void onClear() {
    }

    @Override
    public void onReset() {
    }
}

