/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Litmus;

public class SqlDynamicParam
extends SqlNode {
    private final int index;

    public SqlDynamicParam(int index, SqlParserPos pos) {
        super(pos);
        this.index = index;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlDynamicParam(this.index, pos);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.DYNAMIC_PARAM;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.dynamicParam(this.index);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateDynamicParam(this);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return SqlMonotonicity.CONSTANT;
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlDynamicParam)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlDynamicParam that = (SqlDynamicParam)node;
        if (this.index != that.index) {
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }
}

