/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.distribution;

import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitDef;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTraitDef;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionType;

public class DistributionTrait
implements RelTrait {
    private final DistributionTraitDef traitDef;
    private final DistributionType type;

    DistributionTrait(DistributionTraitDef traitDef, DistributionType type) {
        this.traitDef = traitDef;
        this.type = type;
    }

    public DistributionType getType() {
        return this.type;
    }

    @Override
    public RelTraitDef getTraitDef() {
        return this.traitDef;
    }

    @Override
    public boolean satisfies(RelTrait targetTrait) {
        if (!(targetTrait instanceof DistributionTrait)) {
            return false;
        }
        if (this.traitDef.getMemberCount() == 1) {
            return true;
        }
        DistributionTrait targetTrait0 = (DistributionTrait)targetTrait;
        if (targetTrait0.getType() == DistributionType.ANY) {
            return true;
        }
        if (this.type == DistributionType.REPLICATED && targetTrait0.getType() == DistributionType.ROOT) {
            return true;
        }
        return this.equals(targetTrait);
    }

    public boolean isFullResultSetOnAllParticipants() {
        if (this.traitDef.getMemberCount() == 1) {
            return true;
        }
        if (this.type == DistributionType.ROOT) {
            return true;
        }
        return this.type == DistributionType.REPLICATED;
    }

    @Override
    public void register(RelOptPlanner planner) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionTrait other = (DistributionTrait)o;
        return this.traitDef.equals(other.traitDef) && this.type == other.type;
    }

    @Override
    public int hashCode() {
        return 31 * this.traitDef.hashCode() + this.type.hashCode();
    }

    @Override
    public String toString() {
        return this.type.name();
    }
}

