/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.predicate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.param.NumericPrecedenceParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;

public final class HazelcastComparisonPredicateUtils {
    private HazelcastComparisonPredicateUtils() {
    }

    public static boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        SqlNode first = binding.operand(0);
        SqlNode second = binding.operand(1);
        HazelcastSqlValidator validator = binding.getValidator();
        RelDataType firstType = validator.deriveType(binding.getScope(), first);
        RelDataType secondType = validator.deriveType(binding.getScope(), second);
        assert (firstType.getSqlTypeName() != SqlTypeName.NULL);
        assert (secondType.getSqlTypeName() != SqlTypeName.NULL);
        return HazelcastComparisonPredicateUtils.checkOperandTypes(binding, throwOnFailure, validator, first, firstType, second, secondType);
    }

    private static boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure, HazelcastSqlValidator validator, SqlNode first, RelDataType firstType, SqlNode second, RelDataType secondType) {
        RelDataType winningType = HazelcastTypeUtils.withHigherPrecedence(firstType, secondType);
        if (winningType == firstType) {
            return HazelcastComparisonPredicateUtils.checkOperandTypesWithPrecedence(callBinding, throwOnFailure, validator, first, firstType, second, secondType, 1);
        }
        assert (winningType == secondType);
        return HazelcastComparisonPredicateUtils.checkOperandTypesWithPrecedence(callBinding, throwOnFailure, validator, second, secondType, first, firstType, 0);
    }

    private static boolean checkOperandTypesWithPrecedence(HazelcastCallBinding callBinding, boolean throwOnFailure, HazelcastSqlValidator validator, SqlNode high, RelDataType highType, SqlNode low, RelDataType lowType, int lowIndex) {
        boolean valid;
        QueryDataType highHZType = HazelcastTypeUtils.toHazelcastType(highType.getSqlTypeName());
        QueryDataType lowHZType = HazelcastTypeUtils.toHazelcastType(lowType.getSqlTypeName());
        if (highHZType.getTypeFamily().isNumeric()) {
            HazelcastComparisonPredicateUtils.setNumericParameterConverter(validator, high, highHZType);
            HazelcastComparisonPredicateUtils.setNumericParameterConverter(validator, low, highHZType);
        }
        if (highHZType.getTypeFamily() == lowHZType.getTypeFamily()) {
            return true;
        }
        boolean bl = valid = HazelcastComparisonPredicateUtils.bothOperandsAreNumeric(highHZType, lowHZType) || HazelcastComparisonPredicateUtils.bothOperandsAreTemporalAndLowOperandCanBeConvertedToHighOperand(highHZType, lowHZType) || HazelcastComparisonPredicateUtils.highOperandIsTemporalAndLowOperandIsLiteralOfVarcharType(highHZType, lowHZType, low);
        if (!valid) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        RelDataType newLowType = validator.getTypeFactory().createTypeWithNullability(highType, lowType.isNullable());
        validator.getTypeCoercion().coerceOperandType(callBinding.getScope(), callBinding.getCall(), lowIndex, newLowType);
        return true;
    }

    private static boolean bothOperandsAreNumeric(QueryDataType highHZType, QueryDataType lowHZType) {
        return highHZType.getTypeFamily().isNumeric() && lowHZType.getTypeFamily().isNumeric();
    }

    private static boolean bothOperandsAreTemporalAndLowOperandCanBeConvertedToHighOperand(QueryDataType highHZType, QueryDataType lowHZType) {
        return highHZType.getTypeFamily().isTemporal() && lowHZType.getTypeFamily().isTemporal() && lowHZType.getConverter().canConvertTo(highHZType.getTypeFamily());
    }

    private static boolean highOperandIsTemporalAndLowOperandIsLiteralOfVarcharType(QueryDataType highHZType, QueryDataType lowHZType, SqlNode low) {
        return highHZType.getTypeFamily().isTemporal() && lowHZType.getTypeFamily() == QueryDataTypeFamily.VARCHAR && low instanceof SqlLiteral;
    }

    private static void setNumericParameterConverter(HazelcastSqlValidator validator, SqlNode node, QueryDataType type) {
        if (node.getKind() == SqlKind.DYNAMIC_PARAM) {
            SqlDynamicParam node0 = (SqlDynamicParam)node;
            NumericPrecedenceParameterConverter converter = new NumericPrecedenceParameterConverter(node0.getIndex(), node.getParserPosition(), type);
            validator.setParameterConverter(node0.getIndex(), converter);
        }
    }
}

