/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.string;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBindingSignatureErrorAware;
import com.hazelcast.sql.impl.calcite.validate.literal.LiteralUtils;
import com.hazelcast.sql.impl.calcite.validate.operand.AnyOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastFunction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class HazelcastTrimFunction
extends HazelcastFunction
implements HazelcastCallBindingSignatureErrorAware {
    public static final HazelcastTrimFunction INSTANCE = new HazelcastTrimFunction();

    private HazelcastTrimFunction() {
        super("TRIM", SqlKind.TRIM, ReturnTypes.ARG2_NULLABLE, new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR), SqlFunctionCategory.STRING);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(3);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (binding.getOperandCount() == 2) {
            return new OperandCheckerProgram(AnyOperandChecker.INSTANCE, TypedOperandChecker.VARCHAR).check(binding, throwOnFailure);
        }
        assert (binding.getOperandCount() == 3);
        return new OperandCheckerProgram(AnyOperandChecker.INSTANCE, TypedOperandChecker.VARCHAR, TypedOperandChecker.VARCHAR).check(binding, throwOnFailure);
    }

    @Override
    public Collection<SqlNode> getOperandsForSignatureError(SqlCall call) {
        Object fromOperand = call.operand(1);
        Object targetOperand = call.operand(2);
        SqlTypeName literalType = LiteralUtils.literalTypeName(fromOperand);
        if (literalType == SqlTypeName.VARCHAR && " ".equals(((SqlLiteral)fromOperand).getValueAs(String.class))) {
            return Collections.singletonList(targetOperand);
        }
        return Arrays.asList(fromOperand, targetOperand);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        assert (call.operand(0) instanceof SqlLiteral) : call.operand(0);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        writer.endFunCall(frame);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 3);
        return "{0}([BOTH|LEADING|TRAILING] {1} FROM {2})";
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        switch (operands.length) {
            case 1: {
                operands = new SqlNode[]{SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO), SqlLiteral.createCharString(" ", pos), operands[0]};
                break;
            }
            case 3: {
                assert (operands[0] instanceof SqlLiteral && ((SqlLiteral)operands[0]).getValue() instanceof SqlTrimFunction.Flag);
                if (operands[1] != null) break;
                operands[1] = SqlLiteral.createCharString(" ", pos);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid operand count " + Arrays.toString(operands));
            }
        }
        return super.createCall(functionQualifier, pos, operands);
    }
}

