/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.RestClientException;
import com.hazelcast.aws.RetryUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;

final class RestClient {
    private static final int HTTP_OK = 200;
    private final String url;
    private final List<Parameter> headers = new ArrayList<Parameter>();
    private String body;
    private int readTimeoutSeconds;
    private int connectTimeoutSeconds;
    private int retries;

    private RestClient(String url) {
        this.url = url;
    }

    static RestClient create(String url) {
        return new RestClient(url);
    }

    RestClient withHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.add(new Parameter(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    RestClient withBody(String body) {
        this.body = body;
        return this;
    }

    RestClient withReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return this;
    }

    RestClient withConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return this;
    }

    RestClient withRetries(int retries) {
        this.retries = retries;
        return this;
    }

    String get() {
        return this.callWithRetries("GET");
    }

    String post() {
        return this.callWithRetries("POST");
    }

    private String callWithRetries(String method) {
        return RetryUtils.retry(() -> this.call(method), this.retries);
    }

    private String call(String method) {
        HttpURLConnection connection = null;
        try {
            URL urlToConnect = new URL(this.url);
            connection = (HttpURLConnection)urlToConnect.openConnection();
            connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(this.readTimeoutSeconds));
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(this.connectTimeoutSeconds));
            connection.setRequestMethod(method);
            for (Parameter header : this.headers) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            if (this.body != null) {
                byte[] bodyData = this.body.getBytes(StandardCharsets.UTF_8);
                connection.setDoOutput(true);
                connection.setRequestProperty("charset", "utf-8");
                connection.setRequestProperty("Content-Length", Integer.toString(bodyData.length));
                try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
                    outputStream.write(bodyData);
                    outputStream.flush();
                }
            }
            this.checkHttpOk(method, connection);
            String string = RestClient.read(connection.getInputStream());
            return string;
        }
        catch (IOException e) {
            throw new RestClientException("Failure in executing REST call", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void checkHttpOk(String method, HttpURLConnection connection) throws IOException {
        if (connection.getResponseCode() != 200) {
            String errorMessage;
            try {
                errorMessage = RestClient.read(connection.getErrorStream());
            }
            catch (Exception e) {
                throw new RestClientException(String.format("Failure executing: %s at: %s", method, this.url), connection.getResponseCode());
            }
            throw new RestClientException(String.format("Failure executing: %s at: %s. Message: %s", method, this.url, errorMessage), connection.getResponseCode());
        }
    }

    private static String read(InputStream stream) {
        if (stream == null) {
            return null;
        }
        Scanner scanner = new Scanner(stream, "UTF-8");
        scanner.useDelimiter("\\Z");
        return scanner.next();
    }

    private static final class Parameter {
        private final String key;
        private final String value;

        private Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        private String getKey() {
            return this.key;
        }

        private String getValue() {
            return this.value;
        }
    }
}

