/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.portable.EmptyObjectDataOutput;
import com.hazelcast.internal.serialization.impl.portable.PortableContext;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class ClassDefinitionWriter
implements PortableWriter {
    private final PortableContext context;
    private final ClassDefinitionBuilder builder;

    ClassDefinitionWriter(PortableContext context, int factoryId, int classId, int version) {
        this.context = context;
        this.builder = new ClassDefinitionBuilder(factoryId, classId, version);
    }

    ClassDefinitionWriter(PortableContext context, ClassDefinitionBuilder builder) {
        this.context = context;
        this.builder = builder;
    }

    @Override
    public void writeInt(@Nonnull String fieldName, int value) {
        this.builder.addIntField(fieldName);
    }

    @Override
    public void writeLong(@Nonnull String fieldName, long value) {
        this.builder.addLongField(fieldName);
    }

    @Override
    public void writeUTF(@Nonnull String fieldName, @Nullable String str) {
        this.writeString(fieldName, str);
    }

    @Override
    public void writeString(@Nonnull String fieldName, @Nullable String value) {
        this.builder.addStringField(fieldName);
    }

    @Override
    public void writeBoolean(@Nonnull String fieldName, boolean value) {
        this.builder.addBooleanField(fieldName);
    }

    @Override
    public void writeByte(@Nonnull String fieldName, byte value) {
        this.builder.addByteField(fieldName);
    }

    @Override
    public void writeChar(@Nonnull String fieldName, int value) {
        this.builder.addCharField(fieldName);
    }

    @Override
    public void writeDouble(@Nonnull String fieldName, double value) {
        this.builder.addDoubleField(fieldName);
    }

    @Override
    public void writeFloat(@Nonnull String fieldName, float value) {
        this.builder.addFloatField(fieldName);
    }

    @Override
    public void writeShort(@Nonnull String fieldName, short value) {
        this.builder.addShortField(fieldName);
    }

    @Override
    public void writeByteArray(@Nonnull String fieldName, byte[] bytes) {
        this.builder.addByteArrayField(fieldName);
    }

    @Override
    public void writeBooleanArray(@Nonnull String fieldName, boolean[] booleans) {
        this.builder.addBooleanArrayField(fieldName);
    }

    @Override
    public void writeCharArray(@Nonnull String fieldName, char[] chars) {
        this.builder.addCharArrayField(fieldName);
    }

    @Override
    public void writeIntArray(@Nonnull String fieldName, int[] ints) {
        this.builder.addIntArrayField(fieldName);
    }

    @Override
    public void writeLongArray(@Nonnull String fieldName, long[] longs) {
        this.builder.addLongArrayField(fieldName);
    }

    @Override
    public void writeDoubleArray(@Nonnull String fieldName, double[] values) {
        this.builder.addDoubleArrayField(fieldName);
    }

    @Override
    public void writeFloatArray(@Nonnull String fieldName, float[] values) {
        this.builder.addFloatArrayField(fieldName);
    }

    @Override
    public void writeShortArray(@Nonnull String fieldName, short[] values) {
        this.builder.addShortArrayField(fieldName);
    }

    @Override
    public void writeUTFArray(@Nonnull String fieldName, @Nullable String[] values) {
        this.writeStringArray(fieldName, values);
    }

    @Override
    public void writeStringArray(@Nonnull String fieldName, @Nullable String[] values) {
        this.builder.addStringArrayField(fieldName);
    }

    @Override
    public void writePortable(@Nonnull String fieldName, @Nullable Portable portable) throws IOException {
        if (portable == null) {
            throw new HazelcastSerializationException("Cannot write null portable without explicitly registering class definition!");
        }
        int version = SerializationUtil.getPortableVersion(portable, this.context.getVersion());
        ClassDefinition nestedClassDef = this.createNestedClassDef(portable, new ClassDefinitionBuilder(portable.getFactoryId(), portable.getClassId(), version));
        this.builder.addPortableField(fieldName, nestedClassDef);
    }

    @Override
    public void writeNullPortable(@Nonnull String fieldName, int factoryId, int classId) {
        ClassDefinition nestedClassDef = this.context.lookupClassDefinition(factoryId, classId, this.context.getVersion());
        if (nestedClassDef == null) {
            throw new HazelcastSerializationException("Cannot write null portable without explicitly registering class definition!");
        }
        this.builder.addPortableField(fieldName, nestedClassDef);
    }

    @Override
    public void writeDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        this.builder.addDecimalField(fieldName);
    }

    @Override
    public void writeTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        this.builder.addTimeField(fieldName);
    }

    @Override
    public void writeDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        this.builder.addDateField(fieldName);
    }

    @Override
    public void writeTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        this.builder.addTimestampField(fieldName);
    }

    @Override
    public void writeTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        this.builder.addTimestampWithTimezoneField(fieldName);
    }

    @Override
    public void writePortableArray(@Nonnull String fieldName, Portable[] portables) throws IOException {
        if (portables == null || portables.length == 0) {
            throw new HazelcastSerializationException("Cannot write null portable array without explicitly registering class definition!");
        }
        Portable p = portables[0];
        int classId = p.getClassId();
        for (int i = 1; i < portables.length; ++i) {
            if (portables[i].getClassId() == classId) continue;
            throw new IllegalArgumentException("Detected different class-ids in portable array!");
        }
        int version = SerializationUtil.getPortableVersion(p, this.context.getVersion());
        ClassDefinition nestedClassDef = this.createNestedClassDef(p, new ClassDefinitionBuilder(p.getFactoryId(), classId, version));
        this.builder.addPortableArrayField(fieldName, nestedClassDef);
    }

    @Override
    public void writeDecimalArray(@Nonnull String fieldName, @Nullable BigDecimal[] values) {
        this.builder.addDecimalArrayField(fieldName);
    }

    @Override
    public void writeTimeArray(@Nonnull String fieldName, @Nullable LocalTime[] values) {
        this.builder.addTimeArrayField(fieldName);
    }

    @Override
    public void writeDateArray(@Nonnull String fieldName, @Nullable LocalDate[] values) {
        this.builder.addDateArrayField(fieldName);
    }

    @Override
    public void writeTimestampArray(@Nonnull String fieldName, @Nullable LocalDateTime[] values) {
        this.builder.addTimestampArrayField(fieldName);
    }

    @Override
    public void writeTimestampWithTimezoneArray(@Nonnull String fieldName, @Nullable OffsetDateTime[] values) {
        this.builder.addTimestampWithTimezoneArrayField(fieldName);
    }

    @Override
    @Nonnull
    public ObjectDataOutput getRawDataOutput() {
        return new EmptyObjectDataOutput();
    }

    private ClassDefinition createNestedClassDef(Portable portable, ClassDefinitionBuilder nestedBuilder) throws IOException {
        ClassDefinitionWriter writer = new ClassDefinitionWriter(this.context, nestedBuilder);
        portable.writePortable(writer);
        return this.context.registerClassDefinition(nestedBuilder.build());
    }

    ClassDefinition registerAndGet() {
        ClassDefinition cd = this.builder.build();
        return this.context.registerClassDefinition(cd);
    }
}

