/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.metadata;

import com.hazelcast.com.google.common.collect.ImmutableMultimap;
import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.com.google.common.collect.Iterables;
import com.hazelcast.com.google.common.collect.Lists;
import com.hazelcast.com.google.common.collect.Maps;
import com.hazelcast.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.SingleRel;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rel.core.Correlate;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinInfo;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.SetOp;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.Permutation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelMdUniqueKeys
implements MetadataHandler<BuiltInMetadata.UniqueKeys> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.UNIQUE_KEYS.method, new RelMdUniqueKeys());

    private RelMdUniqueKeys() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.UniqueKeys> getDef() {
        return BuiltInMetadata.UniqueKeys.DEF;
    }

    public Set<ImmutableBitSet> getUniqueKeys(Filter rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Sort rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Correlate rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getLeft(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(TableModify rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Project rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return this.getProjectUniqueKeys(rel, mq, ignoreNulls, rel.getProjects());
    }

    public Set<ImmutableBitSet> getUniqueKeys(Calc rel, RelMetadataQuery mq, boolean ignoreNulls) {
        RexProgram program = rel.getProgram();
        Permutation permutation = program.getPermutation();
        return this.getProjectUniqueKeys(rel, mq, ignoreNulls, Lists.transform(program.getProjectList(), program::expandLocalRef));
    }

    private Set<ImmutableBitSet> getProjectUniqueKeys(SingleRel rel, RelMetadataQuery mq, boolean ignoreNulls, List<RexNode> projExprs) {
        ImmutableMultimap.Builder<Integer, Integer> inToOutPosBuilder = ImmutableMultimap.builder();
        ImmutableBitSet.Builder mappedInColumnsBuilder = ImmutableBitSet.builder();
        for (int i = 0; i < projExprs.size(); ++i) {
            RexNode projExpr = projExprs.get(i);
            if (!(projExpr instanceof RexInputRef)) continue;
            int inputIndex = ((RexInputRef)projExpr).getIndex();
            inToOutPosBuilder.put(inputIndex, i);
            mappedInColumnsBuilder.set(inputIndex);
        }
        ImmutableBitSet inColumnsUsed = mappedInColumnsBuilder.build();
        if (inColumnsUsed.isEmpty()) {
            return ImmutableSet.of();
        }
        Set<ImmutableBitSet> childUniqueKeySet = mq.getUniqueKeys(rel.getInput(), ignoreNulls);
        if (childUniqueKeySet == null) {
            return ImmutableSet.of();
        }
        Map mapInToOutPos = Maps.transformValues(inToOutPosBuilder.build().asMap(), ImmutableBitSet::of);
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (ImmutableBitSet colMask : childUniqueKeySet) {
            ImmutableBitSet.Builder tmpMask = ImmutableBitSet.builder();
            if (!inColumnsUsed.contains(colMask)) continue;
            Iterable product = Linq4j.product(Iterables.transform(colMask, in -> Iterables.filter(((ImmutableBitSet)mapInToOutPos.get(in)).powerSet(), bs -> !bs.isEmpty())));
            resultBuilder.addAll(Iterables.transform(product, ImmutableBitSet::union));
        }
        return resultBuilder.build();
    }

    public Set<ImmutableBitSet> getUniqueKeys(Join rel, RelMetadataQuery mq, boolean ignoreNulls) {
        if (!rel.getJoinType().projectsRight()) {
            return mq.getUniqueKeys(rel.getLeft(), ignoreNulls);
        }
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        HashSet<ImmutableBitSet> retSet = new HashSet<ImmutableBitSet>();
        Set<ImmutableBitSet> leftSet = mq.getUniqueKeys(left, ignoreNulls);
        HashSet<ImmutableBitSet> rightSet = null;
        Set<ImmutableBitSet> tmpRightSet = mq.getUniqueKeys(right, ignoreNulls);
        int nFieldsOnLeft = left.getRowType().getFieldCount();
        if (tmpRightSet != null) {
            rightSet = new HashSet<ImmutableBitSet>();
            for (ImmutableBitSet colMask : tmpRightSet) {
                ImmutableBitSet.Builder tmpMask = ImmutableBitSet.builder();
                for (int bit : colMask) {
                    tmpMask.set(bit + nFieldsOnLeft);
                }
                rightSet.add(tmpMask.build());
            }
            if (leftSet != null) {
                for (ImmutableBitSet colMaskRight : rightSet) {
                    for (ImmutableBitSet colMaskLeft : leftSet) {
                        retSet.add(colMaskLeft.union(colMaskRight));
                    }
                }
            }
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        Boolean leftUnique = mq.areColumnsUnique(left, joinInfo.leftSet(), ignoreNulls);
        Boolean rightUnique = mq.areColumnsUnique(right, joinInfo.rightSet(), ignoreNulls);
        if (rightUnique != null && rightUnique.booleanValue() && leftSet != null && !rel.getJoinType().generatesNullsOnLeft()) {
            retSet.addAll(leftSet);
        }
        if (leftUnique != null && leftUnique.booleanValue() && rightSet != null && !rel.getJoinType().generatesNullsOnRight()) {
            retSet.addAll(rightSet);
        }
        return retSet;
    }

    public Set<ImmutableBitSet> getUniqueKeys(Aggregate rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return ImmutableSet.of(rel.getGroupSet());
    }

    public Set<ImmutableBitSet> getUniqueKeys(SetOp rel, RelMetadataQuery mq, boolean ignoreNulls) {
        if (!rel.all) {
            return ImmutableSet.of(ImmutableBitSet.range(rel.getRowType().getFieldCount()));
        }
        return ImmutableSet.of();
    }

    public Set<ImmutableBitSet> getUniqueKeys(TableScan rel, RelMetadataQuery mq, boolean ignoreNulls) {
        List<ImmutableBitSet> keys = rel.getTable().getKeys();
        for (ImmutableBitSet key : keys) {
            assert (rel.getTable().isKey(key));
        }
        return ImmutableSet.copyOf(keys);
    }

    public Set<ImmutableBitSet> getUniqueKeys(RelNode rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return null;
    }
}

