/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.util.SqlShuttle;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import java.util.ArrayDeque;
import java.util.Deque;

public abstract class SqlScopedShuttle
extends SqlShuttle {
    private final Deque<SqlValidatorScope> scopes = new ArrayDeque<SqlValidatorScope>();

    protected SqlScopedShuttle(SqlValidatorScope initialScope) {
        this.scopes.push(initialScope);
    }

    @Override
    public final SqlNode visit(SqlCall call) {
        SqlValidatorScope oldScope = this.scopes.peek();
        SqlValidatorScope newScope = oldScope.getOperandScope(call);
        this.scopes.push(newScope);
        SqlNode result = this.visitScoped(call);
        this.scopes.pop();
        return result;
    }

    protected SqlNode visitScoped(SqlCall call) {
        return super.visit(call);
    }

    protected SqlValidatorScope getScope() {
        return this.scopes.peek();
    }
}

