/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operand;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandChecker;

public abstract class AbstractOperandChecker
implements OperandChecker {
    protected AbstractOperandChecker() {
    }

    @Override
    public boolean check(HazelcastCallBinding callBinding, boolean throwOnFailure, int operandIndex) {
        HazelcastSqlValidator validator = callBinding.getValidator();
        Object operand = callBinding.getCall().operand(operandIndex);
        if (((SqlNode)operand).getKind() == SqlKind.DYNAMIC_PARAM) {
            SqlDynamicParam operand0 = (SqlDynamicParam)operand;
            RelDataType type = this.getTargetType(validator.getTypeFactory(), true);
            validator.setValidatedNodeType((SqlNode)operand, type);
            ParameterConverter converter = this.parameterConverter(operand0);
            validator.setParameterConverter(operand0.getIndex(), converter);
            return true;
        }
        RelDataType operandType = validator.deriveType(callBinding.getScope(), (SqlNode)operand);
        assert (operandType.getSqlTypeName() != SqlTypeName.NULL) : "Operand type is not resolved";
        if (this.matchesTargetType(operandType)) {
            return true;
        }
        if (this.coerce(validator, callBinding, (SqlNode)operand, operandType, operandIndex)) {
            return true;
        }
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    protected abstract RelDataType getTargetType(RelDataTypeFactory var1, boolean var2);

    protected abstract boolean matchesTargetType(RelDataType var1);

    protected abstract ParameterConverter parameterConverter(SqlDynamicParam var1);

    protected abstract boolean coerce(HazelcastSqlValidator var1, HazelcastCallBinding var2, SqlNode var3, RelDataType var4, int var5);
}

