/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.impl.AbstractRFC1522Codec;
import com.helger.base.codec.impl.QuotedPrintableCodec;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class RFC1522QCodec
extends AbstractRFC1522Codec {
    public static final boolean DEFAULT_ENCODE_BLANKS = false;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte BLANK = 32;
    private static final byte UNDERSCORE = 95;
    private boolean m_bEncodeBlanks = false;

    @ReturnsMutableCopy
    public static @NonNull BitSet getAllPrintableChars() {
        return (BitSet)PRINTABLE_CHARS.clone();
    }

    public RFC1522QCodec() {
        this(StandardCharsets.UTF_8);
    }

    public RFC1522QCodec(@NonNull Charset charset) {
        super(charset);
    }

    @Override
    protected String getRFC1522Encoding() {
        return "Q";
    }

    public boolean isEncodeBlanks() {
        return this.m_bEncodeBlanks;
    }

    public void setEncodeBlanks(boolean bl) {
        this.m_bEncodeBlanks = bl;
    }

    @Override
    @ReturnsMutableCopy
    protected @Nullable byte[] getEncoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new QuotedPrintableCodec(PRINTABLE_CHARS).getEncoded(byArray, n, n2);
        if (this.m_bEncodeBlanks) {
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != 32) continue;
                byArray2[i] = 95;
            }
        }
        return byArray2;
    }

    @Override
    @ReturnsMutableCopy
    protected @Nullable byte[] getDecoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] != 95) continue;
            bl = true;
            break;
        }
        if (bl) {
            byte[] byArray2 = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = byArray[n + i];
                byArray2[i] = n3 == 95 ? 32 : n3;
            }
            return new QuotedPrintableCodec().getDecoded(byArray2);
        }
        return new QuotedPrintableCodec().getDecoded(byArray, n, n2);
    }

    static {
        int n;
        PRINTABLE_CHARS = new BitSet(256);
        PRINTABLE_CHARS.set(32);
        PRINTABLE_CHARS.set(33);
        PRINTABLE_CHARS.set(34);
        PRINTABLE_CHARS.set(35);
        PRINTABLE_CHARS.set(36);
        PRINTABLE_CHARS.set(37);
        PRINTABLE_CHARS.set(38);
        PRINTABLE_CHARS.set(39);
        PRINTABLE_CHARS.set(40);
        PRINTABLE_CHARS.set(41);
        PRINTABLE_CHARS.set(42);
        PRINTABLE_CHARS.set(43);
        PRINTABLE_CHARS.set(44);
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(47);
        for (n = 48; n <= 57; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(58);
        PRINTABLE_CHARS.set(59);
        PRINTABLE_CHARS.set(60);
        PRINTABLE_CHARS.set(62);
        PRINTABLE_CHARS.set(64);
        for (n = 65; n <= 90; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(91);
        PRINTABLE_CHARS.set(92);
        PRINTABLE_CHARS.set(93);
        PRINTABLE_CHARS.set(94);
        PRINTABLE_CHARS.set(96);
        for (n = 97; n <= 122; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(123);
        PRINTABLE_CHARS.set(124);
        PRINTABLE_CHARS.set(125);
        PRINTABLE_CHARS.set(126);
    }
}

