/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.hashcode;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeCalculator;
import com.helger.base.hashcode.IHashCodeGenerator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public final class HashCodeGenerator
implements IHashCodeGenerator {
    private boolean m_bClosed = false;
    private int m_nHC = 17;

    public HashCodeGenerator(@NonNull Object object) {
        this(object instanceof Class ? (clazz = (Class)object) : object.getClass());
        Class clazz;
    }

    public HashCodeGenerator(@NonNull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        this.append(clazz.getName());
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 != null) {
            this.append(clazz2.getName());
        }
    }

    private HashCodeGenerator(int n) {
        this.m_nHC = n;
    }

    public boolean isClosed() {
        return this.m_bClosed;
    }

    private void _checkClosed() {
        if (this.m_bClosed) {
            throw new IllegalStateException("Hash code cannot be changed anymore!");
        }
    }

    @Override
    public @NonNull HashCodeGenerator append(boolean bl) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, bl);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(byte by) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, by);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(char c) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, c);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(double d) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, d);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(float f) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, f);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(int n) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, n);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(long l) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, l);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(short s) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, s);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable Object object) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, object);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable boolean[] blArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, blArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable boolean[] blArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, blArray, n, n2);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable byte[] byArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, byArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, byArray, n, n2);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable char[] cArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, cArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, cArray, n, n2);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable double[] dArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, dArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable double[] dArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, dArray, n, n2);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable float[] fArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, fArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, fArray, n, n2);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable int[] nArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, nArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, nArray, n, n2);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable long[] lArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, lArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, lArray, n, n2);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable short[] sArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, sArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, sArray, n, n2);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable Object[] objectArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, objectArray);
        return this;
    }

    @Override
    public @NonNull HashCodeGenerator append(@Nullable Object[] objectArray, @Nonnegative int n, @Nonnegative int n2) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, objectArray, n, n2);
        return this;
    }

    @Override
    public int getHashCode() {
        this.m_bClosed = true;
        if (this.m_nHC == 0) {
            this.m_nHC = -1;
        }
        return this.m_nHC;
    }

    @Deprecated(forRemoval=false)
    public boolean equals(Object object) {
        return EqualsHelper.identityEqual(this, object);
    }

    @Deprecated(forRemoval=false)
    public int hashCode() {
        return this.getHashCode();
    }

    public static @NonNull HashCodeGenerator getDerived(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Passed hash code is invalid!");
        }
        return new HashCodeGenerator(n);
    }

    public static int getHashCode(@NonNull Object object, Object ... objectArray) {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object);
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                hashCodeGenerator.append(object2);
            }
        }
        return hashCodeGenerator.getHashCode();
    }

    public static int getHashCode(int n, Object ... objectArray) {
        HashCodeGenerator hashCodeGenerator = HashCodeGenerator.getDerived(n);
        if (objectArray != null) {
            for (Object object : objectArray) {
                hashCodeGenerator.append(object);
            }
        }
        return hashCodeGenerator.getHashCode();
    }
}

