/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.mutable.AbstractMutableNumeric;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class MutableFloat
extends AbstractMutableNumeric<MutableFloat> {
    private float m_fValue;

    public MutableFloat(@NonNull Number number) {
        this(number.floatValue());
    }

    public MutableFloat(float f) {
        this.m_fValue = f;
    }

    @Override
    public float floatValue() {
        return this.m_fValue;
    }

    @Override
    public double doubleValue() {
        return this.m_fValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_fValue;
    }

    @Override
    public long longValue() {
        return (long)this.m_fValue;
    }

    public float inc() {
        return this.inc(1.0f);
    }

    public float inc(float f) {
        this.m_fValue += f;
        this.onAfterChange();
        return this.m_fValue;
    }

    public float inc(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.floatValue());
    }

    public float dec() {
        return this.inc(-1.0f);
    }

    public float dec(float f) {
        return this.inc(-f);
    }

    public float dec(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.floatValue());
    }

    public float divide(float f) {
        this.m_fValue /= f;
        this.onAfterChange();
        return this.m_fValue;
    }

    public float divide(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Divisor");
        return this.divide(number.floatValue());
    }

    public float multiply(float f) {
        this.m_fValue *= f;
        this.onAfterChange();
        return this.m_fValue;
    }

    public float multiply(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Multiplicand");
        return this.multiply(number.floatValue());
    }

    public @NonNull EChange set(float f) {
        if (EqualsHelper.equals(f, this.m_fValue)) {
            return EChange.UNCHANGED;
        }
        this.m_fValue = f;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    public @NonNull EChange set(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.floatValue());
    }

    @Override
    public boolean is0() {
        return EqualsHelper.equals(this.m_fValue, 0.0f);
    }

    @Override
    public boolean isLT0() {
        return CompareHelper.compare(this.m_fValue, 0.0f) < 0;
    }

    @Override
    public boolean isLE0() {
        return CompareHelper.compare(this.m_fValue, 0.0f) <= 0;
    }

    @Override
    public boolean isGT0() {
        return CompareHelper.compare(this.m_fValue, 0.0f) > 0;
    }

    @Override
    public boolean isGE0() {
        return CompareHelper.compare(this.m_fValue, 0.0f) >= 0;
    }

    public float getAndInc() {
        float f = this.floatValue();
        this.inc();
        return f;
    }

    public float incAndGet() {
        this.inc();
        return this.floatValue();
    }

    @Override
    public int compareTo(@NonNull MutableFloat mutableFloat) {
        return CompareHelper.compare(this.m_fValue, mutableFloat.m_fValue);
    }

    @Override
    public @NonNull MutableFloat getClone() {
        return new MutableFloat(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableFloat mutableFloat = (MutableFloat)object;
        return EqualsHelper.equals(this.m_fValue, mutableFloat.m_fValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_fValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_fValue).getToString();
    }
}

